/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentSkipListMap;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.inbound.IdempotentMessageIdStore;
import org.mule.util.concurrent.DaemonThreadFactory;

public class IdempotentInMemoryMessageIdStore
implements IdempotentMessageIdStore {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final ConcurrentSkipListMap store = new ConcurrentSkipListMap();
    protected final ScheduledThreadPoolExecutor scheduler;
    protected final int maxEntries;
    protected final int entryTTL;
    protected final int expirationInterval;

    public IdempotentInMemoryMessageIdStore(String name, int maxEntries, int entryTTL, int expirationInterval) {
        this.maxEntries = maxEntries >= 0 ? maxEntries : Integer.MAX_VALUE;
        this.entryTTL = entryTTL;
        if (expirationInterval <= 0) {
            throw new IllegalArgumentException(CoreMessages.propertyHasInvalidValue("expirationInterval", new Integer(expirationInterval)).toString());
        }
        this.expirationInterval = expirationInterval;
        this.scheduler = new ScheduledThreadPoolExecutor(1);
        this.scheduler.setThreadFactory(new DaemonThreadFactory(name + "-IdempotentMessageIdStore"));
        this.scheduler.scheduleWithFixedDelay(new Expirer(), this.expirationInterval, this.expirationInterval, TimeUnit.SECONDS);
    }

    public boolean containsId(Object id) throws IllegalArgumentException, Exception {
        if (id == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("id").toString());
        }
        return this.store.values().contains(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeId(Object id) throws IllegalArgumentException, Exception {
        if (id == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("id").toString());
        }
        ConcurrentSkipListMap concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            if (this.store.values().contains(id)) {
                return false;
            }
            boolean written = false;
            while (!written) {
                written = this.store.putIfAbsent(new Long(Utils.nanoTime()), id) == null;
            }
            return true;
        }
    }

    protected void expire() {
        int currentSize = this.store.size();
        int excess = currentSize - this.maxEntries;
        if (excess > 0) {
            while (currentSize > this.maxEntries) {
                this.store.pollFirstEntry();
                --currentSize;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Expired " + excess + " excess entries");
            }
        }
        if (this.entryTTL > 0 && currentSize != 0) {
            Long oldestKey;
            long oldestKeyValue;
            Map.Entry oldestEntry;
            long now = Utils.nanoTime();
            int expiredEntries = 0;
            while ((oldestEntry = this.store.firstEntry()) != null && TimeUnit.NANOSECONDS.toSeconds(now - (oldestKeyValue = (oldestKey = (Long)oldestEntry.getKey()).longValue())) >= (long)this.entryTTL) {
                this.store.remove(oldestKey);
                ++expiredEntries;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Expired " + expiredEntries + " old entries");
            }
        }
    }

    protected class Expirer
    implements Runnable {
        protected Expirer() {
        }

        public void run() {
            try {
                IdempotentInMemoryMessageIdStore.this.expire();
            }
            catch (Exception ex) {
                IdempotentInMemoryMessageIdStore.this.logger.error(ex.getMessage(), ex);
            }
        }
    }
}

