/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MuleDtdResolver
implements EntityResolver {
    protected static final Log logger = LogFactory.getLog(MuleDtdResolver.class);
    public static final String DEFAULT_MULE_DTD = "mule-configuration.dtd";
    private static final String SEARCH_PATH = "";
    private EntityResolver delegate;
    private String xsl;
    private static String currentXsl;

    public MuleDtdResolver() {
        this(DEFAULT_MULE_DTD);
    }

    public MuleDtdResolver(String dtdName) {
        this(dtdName, null, null);
    }

    public MuleDtdResolver(String dtdName, String xsl) {
        this(dtdName, xsl, null);
    }

    public MuleDtdResolver(String dtdName, EntityResolver delegate) {
        this(dtdName, null, delegate);
    }

    public MuleDtdResolver(String dtdName, String xsl, EntityResolver delegate) {
        this.delegate = delegate;
        this.xsl = xsl;
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Created Mule Dtd Resolver: ");
            buffer.append("dtd=").append(dtdName).append(", ");
            buffer.append("xsl=").append(xsl).append(", ");
            buffer.append("delegate resolver=").append(delegate).append(", ");
            logger.debug(buffer.toString());
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        logger.debug("Trying to resolve XML entity with public ID: " + publicId + " and system ID: " + systemId);
        InputSource source = null;
        currentXsl = null;
        if (this.delegate != null) {
            source = this.delegate.resolveEntity(publicId, systemId);
        }
        if (source == null && StringUtils.isNotBlank(systemId) && systemId.endsWith(".dtd")) {
            String[] tokens = systemId.split("/");
            String dtdFile = tokens[tokens.length - 1];
            logger.debug("Looking on classpath for " + dtdFile);
            InputStream is = IOUtils.getResourceAsStream(SEARCH_PATH + dtdFile, this.getClass(), true, false);
            if (is != null) {
                source = new InputSource(is);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                logger.debug("Found on classpath mule DTD: " + systemId);
                currentXsl = this.xsl;
                return source;
            }
            logger.debug("Could not find dtd resource on classpath: " + dtdFile);
        }
        return source;
    }

    public String getXslForDtd() {
        return currentXsl;
    }
}

