/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentSkipListMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.beans.ExceptionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.DefaultComponentExceptionStrategy;
import org.mule.impl.DefaultLifecycleAdapterFactory;
import org.mule.impl.MuleSession;
import org.mule.impl.internal.notifications.ModelNotification;
import org.mule.impl.model.AbstractComponent;
import org.mule.impl.model.resolvers.DynamicEntryPointResolver;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.UMOSession;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.UMOLifecycleAdapterFactory;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.model.ModelException;
import org.mule.umo.model.UMOEntryPointResolver;
import org.mule.umo.model.UMOModel;

public abstract class AbstractModel
implements UMOModel {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String name = "mule";
    private UMOEntryPointResolver entryPointResolver = new DynamicEntryPointResolver();
    private UMOLifecycleAdapterFactory lifecycleAdapterFactory = new DefaultLifecycleAdapterFactory();
    private Map components = new ConcurrentSkipListMap();
    protected Map descriptors = new ConcurrentHashMap();
    private AtomicBoolean initialised = new AtomicBoolean(false);
    private AtomicBoolean started = new AtomicBoolean(false);
    private ExceptionListener exceptionListener = new DefaultComponentExceptionStrategy();

    public AbstractModel() {
        this.entryPointResolver = new DynamicEntryPointResolver();
        this.lifecycleAdapterFactory = new DefaultLifecycleAdapterFactory();
        this.components = new ConcurrentSkipListMap();
        this.descriptors = new ConcurrentHashMap();
        this.exceptionListener = new DefaultComponentExceptionStrategy();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UMOEntryPointResolver getEntryPointResolver() {
        return this.entryPointResolver;
    }

    public void setEntryPointResolver(UMOEntryPointResolver entryPointResolver) {
        this.entryPointResolver = entryPointResolver;
    }

    public boolean isComponentRegistered(String name) {
        return this.components.get(name) != null;
    }

    public UMOComponent registerComponent(UMODescriptor descriptor) throws UMOException {
        if (descriptor == null) {
            throw new ModelException(CoreMessages.objectIsNull("UMO Descriptor"));
        }
        if (descriptor.getExceptionListener() == null) {
            descriptor.setExceptionListener(this.exceptionListener);
        }
        if (this.initialised.get()) {
            descriptor.initialise();
        }
        if (this.descriptors.get(descriptor.getName()) != null) {
            throw new ModelException(CoreMessages.descriptorAlreadyExists(descriptor.getName()));
        }
        UMOComponent component = (UMOComponent)this.components.get(descriptor.getName());
        if (component == null) {
            component = this.createComponent(descriptor);
            this.descriptors.put(descriptor.getName(), descriptor);
            this.components.put(descriptor.getName(), component);
        }
        this.logger.debug("Added Mule UMO: " + descriptor.getName());
        if (this.initialised.get()) {
            this.logger.info("Initialising component: " + descriptor.getName());
            component.initialise();
        }
        if (this.started.get()) {
            this.logger.info("Starting component: " + descriptor.getName());
            component.start();
        }
        return component;
    }

    public void unregisterComponent(UMODescriptor descriptor) throws UMOException {
        if (descriptor == null) {
            throw new ModelException(CoreMessages.objectIsNull("UMO Descriptor"));
        }
        if (!this.isComponentRegistered(descriptor.getName())) {
            throw new ModelException(CoreMessages.componentNotRegistered(descriptor.getName()));
        }
        UMOComponent component = (UMOComponent)this.components.remove(descriptor.getName());
        if (component != null) {
            component.stop();
            this.descriptors.remove(descriptor.getName());
            component.dispose();
            this.logger.info("The component: " + descriptor.getName() + " has been unregistered and disposing");
        }
    }

    public UMOLifecycleAdapterFactory getLifecycleAdapterFactory() {
        return this.lifecycleAdapterFactory;
    }

    public void setLifecycleAdapterFactory(UMOLifecycleAdapterFactory lifecycleAdapterFactory) {
        this.lifecycleAdapterFactory = lifecycleAdapterFactory;
    }

    public void dispose() {
        this.fireNotification(new ModelNotification(this, 209));
        Iterator i = this.components.values().iterator();
        while (i.hasNext()) {
            UMOComponent component = (UMOComponent)i.next();
            try {
                component.dispose();
                this.logger.info(component + " has been destroyed successfully");
            }
            catch (Exception e1) {
                this.logger.warn("Failed to dispose component: " + e1.getMessage());
            }
        }
        this.components.clear();
        this.descriptors.clear();
        this.fireNotification(new ModelNotification(this, 210));
    }

    public UMOSession getComponentSession(String muleName) {
        UMOComponent component = (UMOComponent)this.components.get(muleName);
        if (component == null) {
            this.logger.warn("Component: " + muleName + " not found returning null session");
            return null;
        }
        return new MuleSession(component);
    }

    public void stop() throws UMOException {
        this.fireNotification(new ModelNotification(this, 207));
        Iterator i = this.components.values().iterator();
        while (i.hasNext()) {
            UMOComponent component = (UMOComponent)i.next();
            component.stop();
            this.logger.info("Component " + component + " has been stopped successfully");
        }
        this.started.set(false);
        this.initialised.set(false);
        this.fireNotification(new ModelNotification(this, 208));
    }

    public void start() throws UMOException {
        if (!this.initialised.get()) {
            this.initialise();
        }
        if (!this.started.get()) {
            this.fireNotification(new ModelNotification(this, 205));
            Iterator i = this.components.values().iterator();
            while (i.hasNext()) {
                AbstractComponent component = (AbstractComponent)i.next();
                if (component.getDescriptor().getInitialState().equals("started")) {
                    component.start();
                    this.logger.info("Component " + component + " has been started successfully");
                    continue;
                }
                if (component.getDescriptor().getInitialState().equals("paused")) {
                    component.start(true);
                    this.logger.info("Component " + component + " has been started and paused (initial state = 'paused')");
                    continue;
                }
                this.logger.info("Component " + component + " has not been started (initial state = 'stopped')");
            }
            this.started.set(true);
            this.fireNotification(new ModelNotification(this, 206));
        } else {
            this.logger.debug("Model already started");
        }
    }

    public void startComponent(String name) throws UMOException {
        UMOComponent component = (UMOComponent)this.components.get(name);
        if (component == null) {
            throw new ModelException(CoreMessages.componentNotRegistered(name));
        }
        component.start();
        this.logger.info("Mule " + component.toString() + " has been started successfully");
    }

    public void stopComponent(String name) throws UMOException {
        UMOComponent component = (UMOComponent)this.components.get(name);
        if (component == null) {
            throw new ModelException(CoreMessages.componentNotRegistered(name));
        }
        component.stop();
        this.logger.info("mule " + name + " has been stopped successfully");
    }

    public void pauseComponent(String name) throws UMOException {
        UMOComponent component = (UMOComponent)this.components.get(name);
        if (component == null) {
            throw new ModelException(CoreMessages.componentNotRegistered(name));
        }
        component.pause();
        this.logger.info("Mule Component " + name + " has been paused successfully");
    }

    public void resumeComponent(String name) throws UMOException {
        UMOComponent component = (UMOComponent)this.components.get(name);
        if (component == null) {
            throw new ModelException(CoreMessages.componentNotRegistered(name));
        }
        component.resume();
        this.logger.info("Mule Component " + name + " has been resumed successfully");
    }

    public void setComponents(List descriptors) throws UMOException {
        Iterator iterator = descriptors.iterator();
        while (iterator.hasNext()) {
            this.registerComponent((UMODescriptor)iterator.next());
        }
    }

    public void initialise() throws InitialisationException {
        if (!this.initialised.get()) {
            this.fireNotification(new ModelNotification(this, 201));
            if (this.exceptionListener instanceof Initialisable) {
                ((Initialisable)((Object)this.exceptionListener)).initialise();
            }
            UMOComponent component = null;
            Iterator i = this.components.values().iterator();
            while (i.hasNext()) {
                component = (UMOComponent)i.next();
                component.initialise();
                this.logger.info("Component " + component.getDescriptor().getName() + " has been started successfully");
            }
            this.initialised.set(true);
            this.fireNotification(new ModelNotification(this, 202));
        } else {
            this.logger.debug("Model already initialised");
        }
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public UMODescriptor getDescriptor(String name) {
        return (UMODescriptor)this.descriptors.get(name);
    }

    public UMOComponent getComponent(String name) {
        return (UMOComponent)this.components.get(name);
    }

    public Iterator getComponentNames() {
        return this.components.keySet().iterator();
    }

    void fireNotification(UMOServerNotification notification) {
        MuleManager.getInstance().fireNotification(notification);
    }

    protected abstract UMOComponent createComponent(UMODescriptor var1);
}

