/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import junit.framework.Assert;
import org.mule.MuleManager;
import org.mule.impl.DefaultExceptionStrategy;
import org.mule.impl.MuleTransactionConfig;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transaction.TransactionCallback;
import org.mule.transaction.TransactionTemplate;
import org.mule.transaction.XaTransaction;
import org.mule.transaction.XaTransactionFactory;
import org.mule.umo.manager.UMOTransactionManagerFactory;

public abstract class AbstractTxThreadAssociationTestCase
extends AbstractMuleTestCase {
    private TransactionManager tm;
    protected static final int TRANSACTION_TIMEOUT_SECONDS = 3;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        UMOTransactionManagerFactory factory = this.getTransactionManagerFactory();
        this.tm = factory.create();
        AbstractTxThreadAssociationTestCase.assertNotNull("Transaction Manager should be available.", this.tm);
        AbstractTxThreadAssociationTestCase.assertNull("There sould be no current transaction associated.", this.tm.getTransaction());
    }

    public void testTxHandleCommitKeepsThreadAssociation() throws Exception {
        this.tm.setTransactionTimeout(3);
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        AbstractTxThreadAssociationTestCase.assertNotNull("Transaction should have started.", tx);
        AbstractTxThreadAssociationTestCase.assertEquals("TX should have been active", 0, tx.getStatus());
        tx.commit();
        tx = this.tm.getTransaction();
        AbstractTxThreadAssociationTestCase.assertNotNull("Committing via TX handle should NOT disassociated TX from the current thread.", tx);
        AbstractTxThreadAssociationTestCase.assertEquals("TX status should have been COMMITTED.", 3, tx.getStatus());
        Transaction suspended = this.tm.suspend();
        AbstractTxThreadAssociationTestCase.assertTrue("Wrong TX suspended?.", suspended.equals(tx));
        AbstractTxThreadAssociationTestCase.assertNull("TX should've been disassociated from the thread.", this.tm.getTransaction());
        this.tm.resume(null);
        AbstractTxThreadAssociationTestCase.assertNull(this.tm.getTransaction());
    }

    public void testTxManagerCommitDissassociatesThread() throws Exception {
        this.tm.setTransactionTimeout(3);
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        AbstractTxThreadAssociationTestCase.assertNotNull("Transaction should have started.", tx);
        AbstractTxThreadAssociationTestCase.assertEquals("TX should have been active", 0, tx.getStatus());
        this.tm.commit();
        AbstractTxThreadAssociationTestCase.assertNull("Committing via TX Manager should have disassociated TX from the current thread.", this.tm.getTransaction());
    }

    public void testTxManagerRollbackDissassociatesThread() throws Exception {
        this.tm.setTransactionTimeout(3);
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        AbstractTxThreadAssociationTestCase.assertNotNull("Transaction should have started.", tx);
        AbstractTxThreadAssociationTestCase.assertEquals("TX should have been active", 0, tx.getStatus());
        this.tm.rollback();
        AbstractTxThreadAssociationTestCase.assertNull("Committing via TX Manager should have disassociated TX from the current thread.", this.tm.getTransaction());
    }

    public void testAlwaysBeginXaTransactionSuspendResume() throws Exception {
        MuleManager.getInstance().setTransactionManager(this.tm);
        AbstractTxThreadAssociationTestCase.assertNull("There sould be no current transaction associated.", this.tm.getTransaction());
        this.tm.setTransactionTimeout(3);
        MuleTransactionConfig config = new MuleTransactionConfig();
        config.setFactory(new XaTransactionFactory());
        config.setAction((byte)1);
        TransactionTemplate template = new TransactionTemplate(config, new DefaultExceptionStrategy());
        final MuleTransactionConfig nestedConfig = new MuleTransactionConfig();
        nestedConfig.setFactory(new XaTransactionFactory());
        nestedConfig.setAction((byte)1);
        template.execute(new TransactionCallback(){

            public Object doInTransaction() throws Exception {
                TransactionTemplate nestedTemplate = new TransactionTemplate(nestedConfig, new DefaultExceptionStrategy());
                Transaction firstTx = AbstractTxThreadAssociationTestCase.this.tm.getTransaction();
                Assert.assertNotNull(firstTx);
                Assert.assertEquals(firstTx.getStatus(), 0);
                return nestedTemplate.execute(new TransactionCallback(this, firstTx){
                    private final /* synthetic */ Transaction val$firstTx;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$firstTx = val$firstTx;
                    }

                    public Object doInTransaction() throws Exception {
                        Transaction secondTx = AbstractTxThreadAssociationTestCase.access$000(1.access$100(this.this$1)).getTransaction();
                        Assert.assertNotNull(secondTx);
                        Assert.assertEquals(this.val$firstTx.getStatus(), 0);
                        Assert.assertEquals(secondTx.getStatus(), 0);
                        try {
                            AbstractTxThreadAssociationTestCase.access$000(1.access$100(this.this$1)).resume(this.val$firstTx);
                            Assert.fail("Second transaction must be active");
                        }
                        catch (IllegalStateException e) {
                            // empty catch block
                        }
                        try {
                            Transaction currentTx = AbstractTxThreadAssociationTestCase.access$000(1.access$100(this.this$1)).suspend();
                            Assert.assertTrue(currentTx.equals(secondTx));
                            AbstractTxThreadAssociationTestCase.access$000(1.access$100(this.this$1)).resume(this.val$firstTx);
                            Assert.assertEquals(this.val$firstTx, AbstractTxThreadAssociationTestCase.access$000(1.access$100(this.this$1)).getTransaction());
                            Assert.assertEquals(this.val$firstTx.getStatus(), 0);
                            Assert.assertEquals(secondTx.getStatus(), 0);
                            Transaction a = AbstractTxThreadAssociationTestCase.access$000(1.access$100(this.this$1)).suspend();
                            Assert.assertTrue(a.equals(this.val$firstTx));
                            AbstractTxThreadAssociationTestCase.access$000(1.access$100(this.this$1)).resume(secondTx);
                        }
                        catch (Exception e) {
                            Assert.fail("Error: " + e);
                        }
                        return null;
                    }
                });
            }

            static /* synthetic */ AbstractTxThreadAssociationTestCase access$100(1 x0) {
                return x0.AbstractTxThreadAssociationTestCase.this;
            }
        });
        AbstractTxThreadAssociationTestCase.assertNull("Committing via TX Manager should have disassociated TX from the current thread.", this.tm.getTransaction());
    }

    public void testXaTransactionTermination() throws Exception {
        MuleManager.getInstance().setTransactionManager(this.tm);
        AbstractTxThreadAssociationTestCase.assertNull("There sould be no current transaction associated.", this.tm.getTransaction());
        this.tm.setTransactionTimeout(3);
        XaTransaction muleTx = new XaTransaction();
        AbstractTxThreadAssociationTestCase.assertFalse(muleTx.isBegun());
        AbstractTxThreadAssociationTestCase.assertEquals(6, muleTx.getStatus());
        muleTx.begin();
        AbstractTxThreadAssociationTestCase.assertTrue(muleTx.isBegun());
        muleTx.commit();
        Transaction jtaTx = this.tm.getTransaction();
        AbstractTxThreadAssociationTestCase.assertNull("Committing via TX Manager should have disassociated TX from the current thread.", jtaTx);
        AbstractTxThreadAssociationTestCase.assertEquals(6, muleTx.getStatus());
    }

    public void testNoNestedTxStarted() throws Exception {
        MuleManager.getInstance().setTransactionManager(this.tm);
        AbstractTxThreadAssociationTestCase.assertNull("There sould be no current transaction associated.", this.tm.getTransaction());
        this.tm.setTransactionTimeout(3);
        MuleTransactionConfig config = new MuleTransactionConfig();
        config.setFactory(new XaTransactionFactory());
        config.setAction((byte)1);
        TransactionTemplate template = new TransactionTemplate(config, new DefaultExceptionStrategy());
        final MuleTransactionConfig nestedConfig = new MuleTransactionConfig();
        nestedConfig.setFactory(new XaTransactionFactory());
        nestedConfig.setAction((byte)2);
        template.execute(new TransactionCallback(){

            public Object doInTransaction() throws Exception {
                TransactionTemplate nestedTemplate = new TransactionTemplate(nestedConfig, new DefaultExceptionStrategy());
                return nestedTemplate.execute(new TransactionCallback(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object doInTransaction() throws Exception {
                        return null;
                    }
                });
            }
        });
    }

    protected TransactionManager getTransactionManager() {
        return this.tm;
    }

    protected abstract UMOTransactionManagerFactory getTransactionManagerFactory();
}

