/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public abstract class Sampler {
    protected Log logger = LogFactory.getLog(this.getClass());
    private String onPattern = null;
    private boolean hasFailed = false;
    protected SamplerContext context;

    public Sampler(SamplerContext context) {
        this.context = context;
    }

    protected final MBeanServerConnection getMBeanServerConnection() {
        return this.context.getJmxap().getMBeanServerConnection();
    }

    protected void releaseMbeanServerConnection() {
        this.context.getJmxap().releaseMBeanServerConnection();
    }

    protected final ObjectName[] queryON(String onProto) throws Exception {
        Set<ObjectName> ons = this.context.getObjectNames(onProto);
        if (ons != null) {
            return ons.toArray(new ObjectName[ons.size()]);
        }
        return null;
    }

    protected abstract String getDefaultOnPattern();

    protected String getOnPattern() {
        return this.onPattern;
    }

    public void setOnPattern(String onPattern) {
        this.onPattern = onPattern;
        if (onPattern == null) {
            this.onPattern = this.getDefaultOnPattern();
        }
    }

    public final SampleData sample(SampleData previous) {
        SampleData data = this.newSampleData();
        try {
            data.setSampleTime(System.currentTimeMillis());
            this.poll(data);
            if (data.isValid()) {
                data.compute(previous);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed sampling", e);
        }
        if (data.isValid()) {
            return data;
        }
        return null;
    }

    public String getName() {
        return this.context.getName();
    }

    public String getJmxUrl() {
        return this.context.getJmxUrl();
    }

    public String getServer() {
        return this.context.getServer();
    }

    public String getDomain() {
        return this.context.getDomain();
    }

    public String getCmdId() {
        return this.context.getCmdId();
    }

    protected abstract SampleData newSampleData();

    protected abstract SampleData poll(SampleData var1);

    public boolean isHasFailed() {
        return this.hasFailed;
    }

    public void setHasFailed(boolean hasFailed) {
        this.hasFailed = hasFailed;
    }
}

