/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.ServerData;

public class ServerSampler
extends Sampler {
    public static final String J2EEServer_ON_PATTERN = "*:j2eeType=J2EEServer,*";
    public static final String JVM_ON_PATTERN = "*:j2eeType=JVM,*";
    public static final String GlobalRequestProcessor_ON_PATTERN = "*:type=GlobalRequestProcessor,*";
    public static final String ThreadPool_ON_PATTERN = "*:type=ThreadPool,*";
    public static final String Manager_ON_PATTERN = "*:type=Manager,*";
    public static final String JTAResource_ON_PATTERN = "*:j2eeType=JTAResource,*";
    public static final String JDBCDataSource_ON_PATTERN = "*:j2eeType=JDBCDataSource,*";
    public static final String EntityBean_ON_PATTERN = "*:j2eeType=EntityBean,*";
    public static final String StatelessSessionBean_ON_PATTERN = "*:j2eeType=StatelessSessionBean,*";
    public static final String StatefulSessionBean_ON_PATTERN = "*:j2eeType=StatefulSessionBean,*";
    private ObjectName[] onServer = null;
    private ObjectName[] onJvm = null;
    private ObjectName[] onJtm = null;
    private ObjectName[] onGRP = null;
    private ObjectName[] onThreadPool = null;
    private ObjectName[] onSessions = null;
    private ObjectName[] onDS = null;
    private ObjectName[] onEntity = null;
    private ObjectName[] onSSB = null;
    private ObjectName[] onSFB = null;

    public ServerSampler(SamplerContext context) {
        super(context);
        try {
            this.onServer = this.queryON(J2EEServer_ON_PATTERN);
            this.onJvm = this.queryON(JVM_ON_PATTERN);
            this.onGRP = this.queryON(GlobalRequestProcessor_ON_PATTERN);
            this.onThreadPool = this.queryON(ThreadPool_ON_PATTERN);
            this.onSessions = this.queryON(Manager_ON_PATTERN);
            this.onJtm = this.queryON(JTAResource_ON_PATTERN);
            this.onDS = this.queryON(JDBCDataSource_ON_PATTERN);
            this.onEntity = this.queryON(EntityBean_ON_PATTERN);
            this.onSSB = this.queryON(StatelessSessionBean_ON_PATTERN);
            this.onSFB = this.queryON(StatefulSessionBean_ON_PATTERN);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDefaultOnPattern() {
        return J2EEServer_ON_PATTERN;
    }

    protected SampleData newSampleData() {
        return new ServerData();
    }

    protected SampleData poll(SampleData data) {
        boolean status = true;
        this.pollServer((ServerData)data);
        status = status && data.isValid();
        this.pollJVM((ServerData)data);
        status = status && data.isValid();
        this.pollSessions((ServerData)data);
        status = status && data.isValid();
        this.pollThreadPool((ServerData)data);
        status = status && data.isValid();
        this.pollJTM((ServerData)data);
        status = status && data.isValid();
        this.pollDataSources((ServerData)data);
        status = status && data.isValid();
        this.pollGlobalRequestProcessor((ServerData)data);
        status = status && data.isValid();
        this.pollEntity((ServerData)data);
        status = status && data.isValid();
        this.pollSSB((ServerData)data);
        status = status && data.isValid();
        this.pollSFB((ServerData)data);
        status = status && data.isValid();
        data.setServerInfo(this.getName(), this.getJmxUrl(), this.getServer(), this.getDomain());
        data.setCmdId(this.getCmdId());
        data.setValid(status);
        return data;
    }

    private void pollServer(ServerData data) {
        long totalMem = 0L;
        long usedMem = 0L;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"currentTotalMemory", "currentUsedMemory"};
        if (this.onServer == null) {
            this.logger.warn("MBeanCmd poll -server : cannot poll {0} MBeans", J2EEServer_ON_PATTERN);
            return;
        }
        for (int i = 0; i < this.onServer.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onServer[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                if (al.isEmpty()) continue;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                totalMem += Long.parseLong(att.getValue().toString());
                att = (Attribute)it.next();
                usedMem += Long.parseLong(att.getValue().toString());
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                if (e.getCause() == null) continue;
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setUsedMemory(usedMem);
        data.setMemory(totalMem);
        data.setServerInfo(this.getName(), this.getJmxUrl(), this.getServer(), this.getDomain());
        data.setCmdId(this.getCmdId());
        if (this.onServer.length > 0) {
            data.setObjectName(this.onServer[0]);
        }
    }

    private void pollJVM(ServerData data) {
        int nbThreads = 0;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"allThreadsCount"};
        if (this.onJvm == null) {
            this.logger.warn("MBeanCmd poll -server : cannot poll {0} MBeans", JVM_ON_PATTERN);
            return;
        }
        for (int i = 0; i < this.onJvm.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onJvm[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                if (al.isEmpty()) continue;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                nbThreads += Integer.parseInt(att.getValue().toString());
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                if (e.getCause() == null) continue;
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setThreads(nbThreads);
    }

    private void pollSessions(ServerData data) {
        long nbSess = 0L;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"activeSessions"};
        if (this.onSessions == null) {
            this.logger.warn("MBeanCmd poll -server : cannot poll {0} MBeans", Manager_ON_PATTERN);
            return;
        }
        for (int i = 0; i < this.onSessions.length; ++i) {
            if (this.onSessions[i] == null) continue;
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onSessions[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                if (al.isEmpty()) continue;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                nbSess += (long)((Integer)att.getValue()).intValue();
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                if (e.getCause() == null) continue;
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setSessions(nbSess);
    }

    private void pollGlobalRequestProcessor(ServerData data) {
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"requestCount", "errorCount"};
        long reqCount = 0L;
        long errCount = 0L;
        if (this.onGRP == null) {
            this.logger.warn("MBeanCmd poll -server : cannot poll {0} MBeans", GlobalRequestProcessor_ON_PATTERN);
            return;
        }
        for (int i = 0; i < this.onGRP.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onGRP[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                if (al.isEmpty()) continue;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                reqCount += (long)((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                errCount += (long)((Integer)att.getValue()).intValue();
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                if (e.getCause() == null) continue;
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setHttpRequests(reqCount);
        data.setHttpErrors(errCount);
    }

    private void pollThreadPool(ServerData data) {
        long nbBusy = 0L;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"currentThreadsBusy"};
        if (this.onThreadPool == null) {
            this.logger.warn("MBeanCmd poll -server : cannot poll {0} MBeans", ThreadPool_ON_PATTERN);
            return;
        }
        for (int i = 0; i < this.onThreadPool.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onThreadPool[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                if (al.isEmpty()) continue;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                long busy = ((Integer)att.getValue()).intValue();
                nbBusy += busy == 1L ? 0L : busy;
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                if (e.getCause() == null) continue;
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setPendingHttp(nbBusy);
    }

    private void pollJTM(ServerData data) {
        long txCount = 0L;
        long currentTxGauge = 0L;
        long rolledbackTx = 0L;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"totalCurrentTransactions", "totalCommittedTransactions", "totalRolledbackTransactions"};
        if (this.onJtm == null) {
            this.logger.warn("MBeanCmd poll -server : cannot poll {0} MBeans", JTAResource_ON_PATTERN);
            return;
        }
        for (int i = 0; i < this.onJtm.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onJtm[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                if (al.isEmpty()) continue;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                currentTxGauge += Long.parseLong(att.getValue().toString());
                att = (Attribute)it.next();
                txCount += Long.parseLong(att.getValue().toString());
                att = (Attribute)it.next();
                rolledbackTx += Long.parseLong(att.getValue().toString());
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                if (e.getCause() == null) continue;
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setCommitedTx(txCount);
        data.setRollbackTx(rolledbackTx);
        data.setPendingTx(currentTxGauge);
    }

    private void pollDataSources(ServerData data) {
        int cnxGauge = 0;
        int cnxFails = 0;
        int cnxLeaks = 0;
        int cnxWaits = 0;
        int cnxRejects = 0;
        int cnxBusy = 0;
        int cnxServed = 0;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"currentOpened", "connectionFailures", "connectionLeaks", "waiterCount", "rejectedOpen", "currentBusy", "servedOpen"};
        if (this.onDS == null) {
            this.logger.warn("MBeanCmd poll -server : cannot poll {0} MBeans", JDBCDataSource_ON_PATTERN);
            return;
        }
        for (int i = 0; i < this.onDS.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onDS[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                if (al.isEmpty()) continue;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                cnxGauge += ((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                cnxFails += ((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                cnxLeaks += ((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                cnxWaits += ((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                cnxRejects += ((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                cnxBusy += ((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                cnxServed += ((Integer)att.getValue()).intValue();
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                if (e.getCause() == null) continue;
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setDSCnx(cnxGauge);
        data.setDSFails(cnxFails);
        data.setDSLeaks(cnxLeaks);
        data.setDSWaits(cnxWaits);
        data.setDSRejects(cnxRejects);
        data.setDSCnxBusy(cnxBusy);
        data.setDSServed(cnxServed);
    }

    private void pollEntity(ServerData data) {
        int entCacheNb = 0;
        int entPoolNb = 0;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"cacheSize", "currentInstancePoolSize"};
        if (this.onEntity == null) {
            this.logger.warn("MBeanCmd poll -server : cannot poll {0} MBeans", EntityBean_ON_PATTERN);
            return;
        }
        if (this.onEntity != null) {
            for (int i = 0; i < this.onEntity.length; ++i) {
                try {
                    cnx = this.getMBeanServerConnection();
                    al = cnx.getAttributes(this.onEntity[i], attIds);
                    this.releaseMbeanServerConnection();
                    cnx = null;
                    if (al.isEmpty()) continue;
                    Iterator it = al.iterator();
                    Attribute att = (Attribute)it.next();
                    entCacheNb += ((Integer)att.getValue()).intValue();
                    att = (Attribute)it.next();
                    entPoolNb += ((Integer)att.getValue()).intValue();
                    data.setValid(true);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        data.setEntityCacheNb(entCacheNb);
        data.setEntityPoolNb(entPoolNb);
    }

    private void pollSSB(ServerData data) {
        int ssbCacheNb = 0;
        int ssbPoolNb = 0;
        long ssbCallsNb = 0L;
        MBeanServerConnection cnx = null;
        String attId = null;
        Object att = null;
        if (this.onSSB == null) {
            this.logger.warn("MBeanCmd poll -server : cannot poll {0} MBeans", StatelessSessionBean_ON_PATTERN);
            return;
        }
        for (int i = 0; i < this.onSSB.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                attId = "cacheSize";
                try {
                    att = cnx.getAttribute(this.onSSB[i], attId);
                    ssbCacheNb += ((Integer)att).intValue();
                }
                catch (AttributeNotFoundException ae) {
                    this.logger.warn("MBeanCmd poll -server : attribute {0} not found in {1} MBean", attId, this.onSSB[i]);
                }
                attId = "poolSize";
                try {
                    att = cnx.getAttribute(this.onSSB[i], attId);
                    ssbPoolNb += ((Integer)att).intValue();
                }
                catch (AttributeNotFoundException ae) {
                    this.logger.warn("MBeanCmd poll -server : attribute {0} not found in {1} MBean", attId, this.onSSB[i]);
                }
                attId = "numberOfCalls";
                try {
                    att = cnx.getAttribute(this.onSSB[i], attId);
                    ssbCallsNb += ((Long)att).longValue();
                }
                catch (AttributeNotFoundException ae) {
                    this.logger.warn("MBeanCmd poll -server : attribute {0} not found in {1} MBean", attId, this.onSSB[i]);
                }
                this.releaseMbeanServerConnection();
                cnx = null;
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                if (e.getCause() == null) continue;
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setSsbCacheNb(ssbCacheNb);
        data.setSsbPoolNb(ssbPoolNb);
        data.setSsbCallsNb(ssbCallsNb);
    }

    private void pollSFB(ServerData data) {
        int sfbCacheNb = 0;
        int sfbPoolNb = 0;
        String attId = null;
        Object att = null;
        MBeanServerConnection cnx = null;
        if (this.onSFB == null) {
            this.logger.warn("MBeanCmd poll -server : cannot poll {0} MBeans", StatefulSessionBean_ON_PATTERN);
            return;
        }
        for (int i = 0; i < this.onSFB.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                attId = "cacheSize";
                try {
                    att = cnx.getAttribute(this.onSFB[i], attId);
                    sfbCacheNb += ((Integer)att).intValue();
                }
                catch (AttributeNotFoundException ae) {
                    this.logger.warn("MBeanCmd poll -server : attribute {0} not found in {1} MBean", attId, this.onSFB[i]);
                }
                attId = "poolSize";
                try {
                    att = cnx.getAttribute(this.onSFB[i], attId);
                    sfbPoolNb += ((Integer)att).intValue();
                }
                catch (AttributeNotFoundException ae) {
                    this.logger.warn("MBeanCmd poll -server : attribute {0} not found in {1} MBean", attId, this.onSFB[i]);
                }
                this.releaseMbeanServerConnection();
                cnx = null;
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                if (e.getCause() == null) continue;
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setSfbCacheNb(sfbCacheNb);
        data.setSfbPoolNb(sfbPoolNb);
    }
}

