/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.WebData;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class WebSampler
extends Sampler {
    protected Log logger = LogFactory.getLog(this.getClass());
    private String GRP_ON = "*:type=GlobalRequestProcessor,*";
    private String MANAGER_ON = "*:type=Manager,*";
    private String TP_ON = "*:type=ThreadPool,*";
    private ObjectName onWebStats = null;
    private ObjectName[] onGRP = null;
    private ObjectName[] onSessions = null;
    private ObjectName[] onThreadPool = null;
    private boolean refreshableSessions = true;
    private boolean refreshableGRPs = true;
    private boolean refreshableThreadPools = true;

    public WebSampler(SamplerContext context) {
        super(context);
    }

    public String getGRP_ON() {
        return this.GRP_ON;
    }

    public String getMANAGER_ON() {
        return this.MANAGER_ON;
    }

    public String getTP_ON() {
        return this.TP_ON;
    }

    public String getDefaultOnPattern() {
        return this.getGRP_ON();
    }

    protected SampleData newSampleData() {
        return new WebData();
    }

    protected SampleData poll(SampleData data) {
        boolean status = true;
        this.pollSessions((WebData)data);
        status = status && data.isValid();
        this.pollGlobalRequestProcessor((WebData)data);
        status = status && data.isValid();
        this.pollThreadPool((WebData)data);
        status = status && data.isValid();
        data.setServerInfo(this.getName(), this.getJmxUrl(), this.getServer(), this.getDomain());
        data.setCmdId(this.getCmdId());
        data.setValid(status);
        data.setObjectName(this.getOnWebStats());
        return data;
    }

    private void pollSessions(WebData data) {
        long nbSess = 0L;
        long sessionCnt = 0L;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"activeSessions", "sessionCounter"};
        this.refreshSessionList();
        if (this.onSessions != null) {
            for (int i = 0; i < this.onSessions.length; ++i) {
                if (this.onSessions[i] == null) continue;
                try {
                    cnx = this.getMBeanServerConnection();
                    ObjectName on = this.onSessions[i];
                    al = cnx.getAttributes(on, attIds);
                    this.releaseMbeanServerConnection();
                    cnx = null;
                    if (al.isEmpty()) continue;
                    Iterator it = al.iterator();
                    Attribute att = (Attribute)it.next();
                    nbSess += (long)((Integer)att.getValue()).intValue();
                    att = (Attribute)it.next();
                    sessionCnt += (long)((Integer)att.getValue()).intValue();
                    data.setValid(true);
                    continue;
                }
                catch (InstanceNotFoundException infe) {
                    this.logger.error("{0}", infe.toString());
                    this.refreshableSessions = true;
                    continue;
                }
                catch (Exception e) {
                    this.refreshableSessions = true;
                    e.printStackTrace(System.err);
                }
            }
        }
        data.setSessionGauge(nbSess);
        data.setSessionCount(sessionCnt);
    }

    private void refreshSessionList() {
        if (this.onSessions == null || this.onSessions.length == 0) {
            this.refreshableSessions = true;
        }
        if (this.refreshableSessions) {
            ObjectName[] ons = null;
            try {
                ons = this.queryON("*:type=Manager,*");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.onSessions = ons;
            if (ons != null) {
                this.refreshableSessions = false;
            }
        }
    }

    private void pollGlobalRequestProcessor(WebData data) {
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"requestCount", "errorCount", "processingTime", "maxTime", "bytesSent", "bytesReceived"};
        long reqCount = 0L;
        long errCount = 0L;
        long procTime = 0L;
        long maxTime = 0L;
        long bytesSent = 0L;
        long bytesReceived = 0L;
        this.refreshGRPList();
        if (this.onGRP != null) {
            for (int i = 0; i < this.onGRP.length; ++i) {
                try {
                    cnx = this.getMBeanServerConnection();
                    ObjectName on = this.onGRP[i];
                    al = cnx.getAttributes(on, attIds);
                    this.releaseMbeanServerConnection();
                    cnx = null;
                    if (al.isEmpty()) continue;
                    Iterator it = al.iterator();
                    Attribute att = (Attribute)it.next();
                    reqCount += (long)((Integer)att.getValue()).intValue();
                    att = (Attribute)it.next();
                    errCount += (long)((Integer)att.getValue()).intValue();
                    att = (Attribute)it.next();
                    procTime += ((Long)att.getValue()).longValue();
                    att = (Attribute)it.next();
                    long max = (Long)att.getValue();
                    maxTime = max > maxTime ? max : maxTime;
                    att = (Attribute)it.next();
                    bytesSent += ((Long)att.getValue()).longValue();
                    att = (Attribute)it.next();
                    bytesReceived += ((Long)att.getValue()).longValue();
                    data.setValid(true);
                    continue;
                }
                catch (InstanceNotFoundException infe) {
                    this.logger.error("{0}", infe.toString());
                    this.refreshableSessions = true;
                    continue;
                }
                catch (Exception e) {
                    this.refreshableGRPs = true;
                    data.setValid(false);
                    e.printStackTrace(System.err);
                }
            }
        }
        data.setHttpRequestCount(reqCount);
        data.setHttpErrorsCount(errCount);
        data.setProcTimeCount(procTime);
        data.setMaxProcTime(maxTime);
        data.setBytesSentCount(bytesSent);
        data.setBytesReceivedCount(bytesReceived);
    }

    private void refreshGRPList() {
        if (this.onGRP == null || this.onGRP.length == 0) {
            this.refreshableGRPs = true;
        }
        if (this.refreshableGRPs) {
            ObjectName[] ons = null;
            try {
                ons = this.queryON("*:type=GlobalRequestProcessor,*");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.onGRP = ons;
            if (ons != null) {
                this.refreshableGRPs = false;
            }
        }
    }

    private void refreshTreadPoolList() {
        if (this.onThreadPool == null || this.onThreadPool.length == 0) {
            this.refreshableThreadPools = true;
        }
        if (this.refreshableThreadPools) {
            ObjectName[] ons = null;
            try {
                ons = this.queryON("*:type=ThreadPool,*");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.onThreadPool = ons;
            if (ons != null) {
                this.refreshableThreadPools = false;
            }
        }
    }

    private void pollThreadPool(WebData data) {
        long nbBusy = 0L;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"currentThreadsBusy"};
        this.refreshTreadPoolList();
        if (this.onThreadPool != null) {
            for (int i = 0; i < this.onThreadPool.length; ++i) {
                try {
                    cnx = this.getMBeanServerConnection();
                    ObjectName on = this.onThreadPool[i];
                    al = cnx.getAttributes(on, attIds);
                    this.releaseMbeanServerConnection();
                    cnx = null;
                    if (al.isEmpty()) continue;
                    Iterator it = al.iterator();
                    Attribute att = (Attribute)it.next();
                    long busy = ((Integer)att.getValue()).intValue();
                    nbBusy += busy == 1L ? 0L : busy;
                    data.setValid(true);
                    continue;
                }
                catch (InstanceNotFoundException infe) {
                    this.logger.error("{0}", infe.toString());
                    this.refreshableSessions = true;
                    continue;
                }
                catch (Exception e) {
                    this.refreshableThreadPools = true;
                    data.setValid(false);
                    e.printStackTrace(System.err);
                }
            }
        }
        data.setPendingHttpRequests(nbBusy);
    }

    public ObjectName getOnWebStats() {
        if (this.onWebStats == null) {
            try {
                this.onWebStats = new ObjectName(this.getDomain() + ":type=HttpStatistics,J2EEServer=" + this.getServer());
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
            }
        }
        return this.onWebStats;
    }

    public void setOnWebStats(ObjectName onWebStats) {
        this.onWebStats = onWebStats;
    }
}

