/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.management.MalformedObjectNameException;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxAp;
import org.ow2.jasmine.monitoring.mbeancmd.JmxHelper;
import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SamplerFactory;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.XSampleData;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class XServerSampler {
    private Log logger = LogFactory.getLog(this.getClass());
    private boolean stopped = false;
    private CommandDispatcher commandDispatcher = null;
    private Map<String, String> manageeURLs = new TreeMap<String, String>();
    private String sampleType = null;
    private String onPattern = null;
    private SamplerContext[] contexts = null;
    private String cmdid = null;
    private static final long SECOND = 1000L;

    public XServerSampler(String type) {
        this.sampleType = type;
    }

    public void stopProcessing() {
        this.stopped = true;
    }

    public void addManagee(String name, String jmxUrl) {
        this.manageeURLs.put(name, jmxUrl);
    }

    public void setOnPattern(String objectNameAsString) {
        this.onPattern = objectNameAsString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mbeanPoll(long period, PrintStream out) throws Exception {
        boolean printHeader = true;
        boolean setrunning = false;
        while (!this.stopped) {
            SamplerContext context = null;
            SampleData data = null;
            for (int i = 0; i < this.contexts.length; ++i) {
                context = this.contexts[i];
                Sampler sampler = context.getSampler();
                try {
                    block17: {
                        String thePattern = this.onPattern;
                        if (this.onPattern == null) {
                            thePattern = sampler.getOnPattern();
                        }
                        try {
                            this.logger.debug("Get MBean ObjectNames for " + thePattern, new Object[0]);
                            context.updateOnames(thePattern);
                        }
                        catch (MalformedObjectNameException moe) {
                            this.commandDispatcher.setFailed(moe.getMessage());
                            throw new Exception("moe.getMessage()");
                        }
                        catch (IOException ioe) {
                            sampler.setHasFailed(true);
                            throw ioe;
                        }
                        if (!setrunning) {
                            this.commandDispatcher.setRunning();
                            setrunning = true;
                        }
                        data = null;
                        try {
                            SampleData prevData = context.getPreviousData();
                            data = sampler.sample(prevData);
                            boolean printed = this.printData(data, out, printHeader);
                            if (printed) {
                                printHeader = false;
                                if (!context.isStarted()) {
                                    context.setStarted(true);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!context.isStarted()) break block17;
                            System.err.println("Error sampling managee " + context.getName());
                        }
                    }
                    context.setPreviousData(data);
                }
                catch (Exception me) {}
                continue;
            }
            try {
                Thread.sleep(period * 1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    private boolean printData(SampleData data, PrintStream out, boolean printHeader) {
        if (data == null) {
            return false;
        }
        boolean emptyData = false;
        if (data instanceof XSampleData) {
            XSampleData xData = (XSampleData)data;
            emptyData = xData.getSampleData().isEmpty();
        }
        if (emptyData) {
            return false;
        }
        if (printHeader) {
            out.println(data.getPrintHeader());
            printHeader = false;
        }
        data.printData(out);
        return true;
    }

    private SamplerContext createSamplerContext(String name) throws Exception {
        SamplerContext samplerContext = new SamplerContext();
        samplerContext.setName(name);
        String jmxUrl = JmxHelper.getJmxUrl(name);
        samplerContext.setJmxUrl(jmxUrl);
        samplerContext.setJmxap(new JmxAp(jmxUrl, this.commandDispatcher));
        if (jmxUrl != null && jmxUrl.equals(name)) {
            samplerContext.setAdminNaming(false);
        }
        samplerContext.setUpManagentInfos();
        if (samplerContext.getServer() == null) {
            samplerContext.setServer("unknown_server_name");
            samplerContext.setDomain("unknown_domain");
        }
        samplerContext.setCmdId(this.cmdid);
        Sampler sampler = SamplerFactory.newSampler(this.sampleType, this.onPattern, samplerContext);
        samplerContext.setSampler(sampler);
        return samplerContext;
    }

    public final void process(long period, PrintStream out) throws Exception {
        LinkedList<SamplerContext> samplerContextList = new LinkedList<SamplerContext>();
        for (Map.Entry<String, String> e : this.manageeURLs.entrySet()) {
            String targetName = e.getKey();
            try {
                SamplerContext ctx = this.createSamplerContext(targetName);
                samplerContextList.add(ctx);
            }
            catch (Exception ex) {
                this.commandDispatcher.setFailed(ex.getMessage());
                throw ex;
            }
        }
        this.contexts = samplerContextList.toArray(new SamplerContext[samplerContextList.size()]);
        this.mbeanPoll(period, out);
    }

    public void setCommandDispatcher(CommandDispatcher commandDispatcher) {
        this.commandDispatcher = commandDispatcher;
    }

    public void setCmdId(String c) {
        this.cmdid = c;
    }

    public String getCmdId() {
        return this.cmdid;
    }
}

