/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import java.beans.ExceptionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCallback;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOTransaction;
import org.mule.umo.UMOTransactionConfig;

public class TransactionTemplate {
    private static final Log logger = LogFactory.getLog(TransactionTemplate.class);
    private final UMOTransactionConfig config;
    private final ExceptionListener exceptionListener;

    public TransactionTemplate(UMOTransactionConfig config, ExceptionListener listener) {
        this.config = config;
        this.exceptionListener = listener;
    }

    public Object execute(TransactionCallback callback) throws Exception {
        if (this.config == null || this.config != null && !this.config.isConfigured()) {
            return callback.doInTransaction();
        }
        byte action = this.config.getAction();
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        UMOTransaction suspendedXATx = null;
        if (action == 0 && tx != null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionAvailableButActionIs("None"));
        }
        if (action == 1 && tx != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Transaction action is ACTION_ALWAYS_BEGIN, current TX: " + tx);
            }
            if (tx.isXA()) {
                suspendedXATx = tx;
                this.suspendXATransaction(suspendedXATx);
            } else {
                this.resolveTransaction(tx);
            }
            tx = null;
        } else if (action == 3 && tx == null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionNotAvailableButActionIs("Always Join"));
        }
        if (action == 1 || action == 2 && tx == null) {
            logger.debug("Beginning transaction");
            tx = this.config.getFactory().beginTransaction();
            logger.debug("Transaction successfully started: " + tx);
        } else {
            tx = null;
        }
        try {
            Object result = callback.doInTransaction();
            if (tx != null) {
                this.resolveTransaction(tx);
                if (suspendedXATx != null) {
                    this.resumeXATransaction(suspendedXATx);
                    tx = suspendedXATx;
                }
            }
            return result;
        }
        catch (Exception e) {
            if (this.exceptionListener != null) {
                logger.info("Exception Caught in Transaction template.  Handing off to exception handler: " + this.exceptionListener);
                this.exceptionListener.exceptionThrown(e);
            } else {
                logger.info("Exception Caught in Transaction template without any exception listeners defined, exception is rethrown.");
                if (tx != null) {
                    tx.setRollbackOnly();
                }
            }
            if (tx != null) {
                if (tx.isRollbackOnly()) {
                    logger.debug("Exception caught: rollback transaction", e);
                }
                this.resolveTransaction(tx);
                if (suspendedXATx != null) {
                    this.resumeXATransaction(suspendedXATx);
                }
            }
            if (this.exceptionListener != null) {
                return null;
            }
            throw e;
        }
        catch (Error e) {
            if (tx != null) {
                logger.info("Error caught, rolling back TX " + tx, e);
                tx.rollback();
            }
            throw e;
        }
    }

    protected void resolveTransaction(UMOTransaction tx) throws TransactionException {
        if (tx.isRollbackOnly()) {
            logger.debug("Transaction has been marked rollbackOnly, rolling it back: " + tx);
            tx.rollback();
        } else {
            logger.debug("Committing transaction " + tx);
            tx.commit();
        }
    }

    protected void suspendXATransaction(UMOTransaction tx) throws TransactionException {
        if (logger.isDebugEnabled()) {
            logger.debug("Suspending " + tx);
        }
        tx.suspend();
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully suspended " + tx);
            logger.debug("Unbinding the following TX from the current context: " + tx);
        }
        TransactionCoordination.getInstance().unbindTransaction(tx);
    }

    protected void resumeXATransaction(UMOTransaction tx) throws TransactionException {
        if (logger.isDebugEnabled()) {
            logger.debug("Re-binding and Resuming " + tx);
        }
        TransactionCoordination.getInstance().bindTransaction(tx);
        tx.resume();
    }
}

