/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.util.Map;
import java.util.Properties;
import org.mule.MuleManager;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ConfigurationException;
import org.mule.config.ReaderResource;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.model.ModelFactory;
import org.mule.impl.model.seda.SedaModel;
import org.mule.providers.service.TransportFactory;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.UMOFilter;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOContainerContext;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.MuleObjectHelper;

public class QuickConfigurationBuilder
implements ConfigurationBuilder {
    private static final String MODEL_NOT_SET = "not set";
    private UMOManager manager;
    private UMOModel model;

    public QuickConfigurationBuilder() {
        this.manager = MuleManager.getInstance();
    }

    public QuickConfigurationBuilder(boolean disposeCurrent) {
        if (disposeCurrent) {
            this.disposeCurrent();
        }
        this.manager = MuleManager.getInstance();
    }

    public void disposeCurrent() {
        if (MuleManager.isInstanciated()) {
            MuleManager.getInstance().dispose();
        }
    }

    public void disableAdminAgent() {
        MuleManager.getConfiguration().setServerUrl("");
        if (this.manager != null) {
            try {
                this.manager.unregisterAgent("Mule Admin");
            }
            catch (UMOException e) {
                throw new RuntimeException("Exception trying to remove admin agent", e);
            }
        }
    }

    public void registerModel(String modelType, String name) throws UMOException {
        UMOModel model = ModelFactory.createModel(modelType);
        model.setName(name);
        this.manager.registerModel(model);
    }

    public UMOManager createStartedManager(boolean synchronous, String serverUrl, String modeltype) throws UMOException {
        if (this.manager.isStarted()) {
            throw new InitialisationException(CoreMessages.managerAlreadyStarted(), (Object)this);
        }
        if (serverUrl == null) {
            serverUrl = "";
        }
        MuleManager.getConfiguration().setServerUrl(serverUrl);
        MuleManager.getConfiguration().setSynchronous(synchronous);
        this.model = !MODEL_NOT_SET.equals(modeltype) ? ModelFactory.createModel(modeltype) : ModelFactory.createModel("seda");
        this.manager.registerModel(this.model);
        this.manager.start();
        return this.manager;
    }

    public UMOManager createStartedManager(boolean synchronous, String serverUrl) throws UMOException {
        return this.createStartedManager(synchronous, serverUrl, MODEL_NOT_SET);
    }

    public UMOManager createStartedManager(boolean synchronous, String serverUrl, UMOConnector serverConnector) throws UMOException {
        if (serverConnector == null) {
            throw new IllegalArgumentException("Cannot create started manager from null serverConnector");
        }
        this.manager.registerConnector(serverConnector);
        int param = serverUrl.indexOf(63);
        serverUrl = param == -1 ? serverUrl + '?' : serverUrl + '&';
        serverUrl = serverUrl + "createConnector=" + serverConnector.getName();
        return this.createStartedManager(synchronous, serverUrl);
    }

    public UMODescriptor registerComponentInstance(Object component, String name, UMOEndpointURI listenerEndpointUri) throws UMOException {
        return this.registerComponentInstance(component, name, listenerEndpointUri, null);
    }

    public UMODescriptor registerComponentInstance(Object component, String name, UMOEndpointURI listenerEndpointUri, UMOEndpointURI sendEndpointUri) throws UMOException {
        MuleDescriptor descriptor = new MuleDescriptor();
        descriptor.setName(name);
        descriptor.setImplementationInstance(component);
        UMOEndpoint inboundProvider = null;
        UMOEndpoint outboundProvider = null;
        if (listenerEndpointUri != null) {
            inboundProvider = TransportFactory.createEndpoint(listenerEndpointUri, "receiver");
        }
        if (sendEndpointUri != null) {
            outboundProvider = TransportFactory.createEndpoint(sendEndpointUri, "sender");
        }
        descriptor.setInboundEndpoint(inboundProvider);
        descriptor.setOutboundEndpoint(outboundProvider);
        this.getModel().registerComponent(descriptor);
        return descriptor;
    }

    public UMOComponent registerComponent(String implementation, String name, String inboundEndpoint, String outboundEndpoint, Map properties) throws UMOException {
        UMOEndpoint inEndpoint = null;
        UMOEndpoint outEndpoint = null;
        if (inboundEndpoint != null && (inEndpoint = this.manager.lookupEndpoint(inboundEndpoint)) == null) {
            inEndpoint = this.createEndpoint(inboundEndpoint, null, true);
        }
        if (outboundEndpoint != null && (outEndpoint = this.manager.lookupEndpoint(outboundEndpoint)) == null) {
            outEndpoint = this.createEndpoint(outboundEndpoint, null, false);
        }
        UMODescriptor d = this.createDescriptor(implementation, name, inEndpoint, outEndpoint, properties);
        return this.registerComponent(d);
    }

    public UMOComponent registerComponent(String implementation, String name, UMOEndpoint inEndpoint, UMOEndpoint outEndpoint, Map properties) throws UMOException {
        UMODescriptor d = this.createDescriptor(implementation, name, inEndpoint, outEndpoint, properties);
        return this.registerComponent(d);
    }

    public UMOComponent registerComponent(UMODescriptor descriptor) throws UMOException {
        return this.getModel().registerComponent(descriptor);
    }

    public UMOComponent registerComponent(String implementation, String name, UMOEndpointURI inboundEndpointUri) throws UMOException {
        return this.registerComponent(implementation, name, inboundEndpointUri, null, null);
    }

    public UMOComponent registerComponent(String implementation, String name, UMOEndpointURI inboundEndpointUri, Map properties) throws UMOException {
        return this.registerComponent(implementation, name, inboundEndpointUri, null, properties);
    }

    public UMOComponent registerComponent(String implementation, String name, UMOEndpointURI inboundEndpointUri, UMOEndpointURI outboundEndpointUri) throws UMOException {
        return this.registerComponent(implementation, name, inboundEndpointUri, outboundEndpointUri, null);
    }

    public UMOComponent registerComponent(String implementation, String name, UMOEndpointURI inboundEndpointUri, UMOEndpointURI outboundEndpointUri, Map properties) throws UMOException {
        UMODescriptor d = this.createDescriptor(implementation, name, inboundEndpointUri, outboundEndpointUri, properties);
        return this.getModel().registerComponent(d);
    }

    public UMODescriptor createDescriptor(String implementation, String name, String inboundEndpointUri, String outboundEndpointUri, Map properties) throws UMOException {
        MuleEndpointURI inEndpointUri = null;
        MuleEndpointURI outEndpointUri = null;
        if (inboundEndpointUri != null) {
            inEndpointUri = new MuleEndpointURI(inboundEndpointUri);
        }
        if (outboundEndpointUri != null) {
            outEndpointUri = new MuleEndpointURI(outboundEndpointUri);
        }
        return this.createDescriptor(implementation, name, inEndpointUri, outEndpointUri, properties);
    }

    public UMODescriptor createDescriptor(String implementation, String name, UMOEndpointURI inboundEndpointUri, UMOEndpointURI outboundEndpointUri, Map properties) throws UMOException {
        UMOEndpoint inboundEndpoint = null;
        UMOEndpoint outboundEndpoint = null;
        if (inboundEndpointUri != null) {
            inboundEndpoint = TransportFactory.createEndpoint(inboundEndpointUri, "receiver");
        }
        if (outboundEndpointUri != null) {
            outboundEndpoint = TransportFactory.createEndpoint(outboundEndpointUri, "sender");
        }
        return this.createDescriptor(implementation, name, inboundEndpoint, outboundEndpoint, properties);
    }

    public UMODescriptor createDescriptor(String implementation, String name, UMOEndpoint inboundEndpoint, UMOEndpoint outboundEndpoint, Map properties) throws UMOException {
        MuleDescriptor descriptor = new MuleDescriptor();
        descriptor.setImplementation(implementation);
        descriptor.setName(name);
        if (properties != null) {
            descriptor.getProperties().putAll(properties);
        }
        descriptor.setInboundEndpoint(inboundEndpoint);
        descriptor.setOutboundEndpoint(outboundEndpoint);
        return descriptor;
    }

    public void setContainerContext(UMOContainerContext ctx) throws UMOException {
        this.manager.setContainerContext(ctx);
    }

    public void unregisterComponent(String name) throws UMOException {
        UMODescriptor descriptor = this.model.getDescriptor(name);
        if (descriptor != null) {
            this.getModel().unregisterComponent(descriptor);
        }
    }

    public UMOEndpoint createEndpoint(String uri, String name, boolean inbound) throws UMOException {
        return this.createEndpoint(uri, name, inbound, null, null);
    }

    public UMOEndpoint createEndpoint(String uri, String name, boolean inbound, String transformers) throws UMOException {
        return this.createEndpoint(uri, name, inbound, transformers, null);
    }

    public UMOEndpoint createEndpoint(String uri, String name, boolean inbound, UMOFilter filter) throws UMOException {
        return this.createEndpoint(uri, name, inbound, null, filter);
    }

    public UMOEndpoint createEndpoint(String uri, String name, boolean inbound, String transformers, UMOFilter filter) throws UMOException {
        UMOEndpoint ep = MuleEndpoint.createEndpointFromUri(new MuleEndpointURI(uri), inbound ? "receiver" : "sender");
        ep.setName(name);
        if (transformers != null) {
            String delim = transformers.indexOf(",") > -1 ? "," : " ";
            ep.setTransformer(MuleObjectHelper.getTransformer(transformers, delim));
        }
        ep.setFilter(filter);
        return ep;
    }

    public UMOEndpoint registerEndpoint(String uri, String name, boolean inbound) throws UMOException {
        UMOEndpoint ep = this.createEndpoint(uri, name, inbound);
        ep.initialise();
        this.manager.registerEndpoint(ep);
        return ep;
    }

    public UMOEndpoint registerEndpoint(String uri, String name, boolean inbound, Map properties) throws UMOException {
        UMOEndpoint ep = this.createEndpoint(uri, name, inbound);
        ep.getProperties().putAll(properties);
        ep.initialise();
        this.manager.registerEndpoint(ep);
        return ep;
    }

    public UMOEndpoint registerEndpoint(String uri, String name, boolean inbound, Map properties, UMOFilter filter) throws UMOException {
        UMOEndpoint ep = this.createEndpoint(uri, name, inbound);
        if (properties != null) {
            ep.getProperties().putAll(properties);
        }
        if (filter != null) {
            ep.setFilter(filter);
        }
        ep.initialise();
        this.manager.registerEndpoint(ep);
        return ep;
    }

    public void registerModel(UMOModel model) throws UMOException {
        this.model = model;
        this.manager.registerModel(model);
    }

    public UMOManager getManager() {
        return this.manager;
    }

    public UMOManager configure(String configResources) throws ConfigurationException {
        return this.configure(configResources, null);
    }

    public UMOManager configure(String configResources, String startupPropertiesFile) throws ConfigurationException {
        return this.configure(new ReaderResource[0], null);
    }

    public UMOManager configure(ReaderResource[] configResources) throws ConfigurationException {
        return this.configure(configResources, null);
    }

    public UMOManager configure(ReaderResource[] configResources, Properties startupProperties) throws ConfigurationException {
        try {
            this.manager.start();
        }
        catch (UMOException e) {
            throw new ConfigurationException(e);
        }
        return this.manager;
    }

    public boolean isConfigured() {
        return this.manager != null;
    }

    protected UMOModel getModel() throws UMOException {
        if (this.model == null) {
            this.model = new SedaModel();
            this.model.setName("main");
            this.manager.registerModel(this.model);
        }
        return this.model;
    }
}

