/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.ResettableIterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.SerializationException;
import org.apache.commons.lang.SerializationUtils;
import org.mule.impl.MuleMessage;
import org.mule.routing.AggregationException;
import org.mule.routing.inbound.CorrelationAggregator;
import org.mule.routing.inbound.CorrelationSequenceComparator;
import org.mule.routing.inbound.EventGroup;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;

public class MessageChunkingAggregator
extends CorrelationAggregator {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    protected final Comparator eventComparator = new CorrelationSequenceComparator();

    protected UMOMessage aggregateEvents(EventGroup events) throws AggregationException {
        Object[] collectedEvents = events.toArray();
        UMOEvent firstEvent = collectedEvents[0];
        Arrays.sort(collectedEvents, this.eventComparator);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        try {
            MuleMessage message;
            ResettableIterator iterator = IteratorUtils.arrayIterator(collectedEvents);
            while (iterator.hasNext()) {
                UMOEvent event = (UMOEvent)iterator.next();
                baos.write(event.getMessageAsBytes());
            }
            try {
                message = new MuleMessage(SerializationUtils.deserialize(baos.toByteArray()), firstEvent.getMessage());
            }
            catch (SerializationException e) {
                message = new MuleMessage((Object)baos.toByteArray(), firstEvent.getMessage());
            }
            message.setCorrelationGroupSize(-1);
            message.setCorrelationSequence(-1);
            MuleMessage muleMessage = message;
            return muleMessage;
        }
        catch (Exception e) {
            throw new AggregationException(events, firstEvent.getEndpoint(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(baos);
        }
    }
}

