/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.HashMap;
import java.util.Iterator;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleMessage;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.routing.outbound.AbstractOutboundRouter;
import org.mule.umo.UMOException;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutePathNotFoundException;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.TemplateParser;

public class FilteringOutboundRouter
extends AbstractOutboundRouter {
    private UMOTransformer transformer;
    private UMOFilter filter;
    private boolean useTemplates = false;
    private TemplateParser parser = TemplateParser.createSquareBracesStyleParser();

    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        UMOMessage result = null;
        if (this.endpoints == null || this.endpoints.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), message, null);
        }
        UMOEndpoint ep = this.getEndpoint(0, message);
        try {
            if (synchronous) {
                result = this.send(session, message, ep);
            } else {
                this.dispatch(session, message, ep);
            }
        }
        catch (UMOException e) {
            throw new CouldNotRouteOutboundMessageException(message, ep, (Throwable)e);
        }
        return result;
    }

    public UMOFilter getFilter() {
        return this.filter;
    }

    public void setFilter(UMOFilter filter) {
        this.filter = filter;
    }

    public boolean isMatch(UMOMessage message) throws RoutingException {
        if (this.getFilter() == null) {
            return true;
        }
        if (this.transformer != null) {
            try {
                Object payload = this.transformer.transform(message.getPayload());
                message = new MuleMessage(payload, message);
            }
            catch (TransformerException e) {
                throw new RoutingException(CoreMessages.transformFailedBeforeFilter(), message, (UMOEndpoint)this.endpoints.get(0), e);
            }
        }
        return this.getFilter().accept(message);
    }

    public UMOTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(UMOTransformer transformer) {
        this.transformer = transformer;
    }

    public void addEndpoint(UMOEndpoint endpoint) {
        if (!this.useTemplates && this.parser.isContainsTemplate(endpoint.getEndpointURI().toString())) {
            this.useTemplates = true;
        }
        super.addEndpoint(endpoint);
    }

    public UMOEndpoint getEndpoint(int index, UMOMessage message) throws CouldNotRouteOutboundMessageException {
        if (!this.useTemplates) {
            return (UMOEndpoint)this.endpoints.get(index);
        }
        UMOEndpoint ep = (UMOEndpoint)this.endpoints.get(index);
        String uri = ep.getEndpointURI().toString();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Uri before parsing is: " + uri);
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(ep.getProperties());
        Iterator iterator = message.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            String propertyKey = (String)iterator.next();
            props.put(propertyKey, message.getProperty(propertyKey));
        }
        String newUriString = this.parser.parse(props, uri);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Uri after parsing is: " + uri);
        }
        try {
            MuleEndpointURI newUri = new MuleEndpointURI(newUriString);
            if (!newUri.getScheme().equalsIgnoreCase(ep.getEndpointURI().getScheme())) {
                throw new CouldNotRouteOutboundMessageException(CoreMessages.schemeCannotChangeForRouter(ep.getEndpointURI().getScheme(), newUri.getScheme()), message, ep);
            }
            UMOEndpoint resolvedEndpoint = (UMOEndpoint)ep.clone();
            resolvedEndpoint.setEndpointURI(newUri);
            return resolvedEndpoint;
        }
        catch (EndpointException e) {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.templateCausedMalformedEndpoint(uri, newUriString), message, ep, (Throwable)e);
        }
    }

    public boolean isUseTemplates() {
        return this.useTemplates;
    }

    public void setUseTemplates(boolean useTemplates) {
        this.useTemplates = useTemplates;
    }
}

