/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.model;

import org.mule.impl.MuleDescriptor;
import org.mule.impl.NoSatisfiableMethodsException;
import org.mule.impl.RequestContext;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.InvalidSatsuma;
import org.mule.umo.UMODescriptor;
import org.mule.umo.model.UMOEntryPoint;
import org.mule.umo.model.UMOEntryPointResolver;
import org.mule.util.ClassUtils;

public abstract class AbstractEntryPointDiscoveryTestCase
extends AbstractMuleTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailEntryPointDiscovery() throws Exception {
        UMOEntryPointResolver epd = this.getEntryPointResolver();
        MuleDescriptor descriptor = AbstractEntryPointDiscoveryTestCase.getTestDescriptor("badSatsuma", InvalidSatsuma.class.getName());
        UMOEntryPoint ep = null;
        try {
            ep = epd.resolveEntryPoint(descriptor);
        }
        catch (NoSatisfiableMethodsException e) {
            return;
        }
        AbstractEntryPointDiscoveryTestCase.assertNotNull(ep);
        try {
            RequestContext.setEvent(AbstractEntryPointDiscoveryTestCase.getTestEvent("Hello"));
            ep.invoke(new InvalidSatsuma(), RequestContext.getEventContext());
            AbstractEntryPointDiscoveryTestCase.fail("Should have failed to find entrypoint on Satsuma");
        }
        catch (Exception e) {
        }
        finally {
            RequestContext.setEvent(null);
        }
    }

    public void testEntryPointDiscovery() throws Exception {
        ComponentMethodMapping[] mappings = this.getComponentMappings();
        for (int i = 0; i < mappings.length; ++i) {
            if (mappings[i].isShouldFail()) {
                this.doExpectedFail(mappings[i]);
                continue;
            }
            this.doExpectedPass(mappings[i]);
        }
    }

    private void doExpectedPass(ComponentMethodMapping mapping) throws Exception {
        UMOEntryPointResolver epr = this.getEntryPointResolver();
        UMODescriptor descriptor = this.getDescriptorToResolve(mapping.getComponentClass().getName());
        UMOEntryPoint ep = epr.resolveEntryPoint(descriptor);
        AbstractEntryPointDiscoveryTestCase.assertNotNull(ep);
    }

    private void doExpectedFail(ComponentMethodMapping mapping) throws Exception {
        UMOEntryPointResolver epr = this.getEntryPointResolver();
        UMODescriptor descriptor = this.getDescriptorToResolve(mapping.getComponentClass().getName());
        try {
            UMOEntryPoint ep = epr.resolveEntryPoint(descriptor);
            ep.invoke(ClassUtils.instanciateClass(mapping.getComponentClass(), ClassUtils.NO_ARGS), AbstractEntryPointDiscoveryTestCase.getTestEventContext("blah"));
            AbstractEntryPointDiscoveryTestCase.fail("Resolving should have failed for: " + mapping.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public UMODescriptor getDescriptorToResolve(String className) throws Exception {
        return AbstractEntryPointDiscoveryTestCase.getTestDescriptor("myComponent", className);
    }

    public abstract UMOEntryPointResolver getEntryPointResolver();

    public abstract ComponentMethodMapping[] getComponentMappings();

    public class ComponentMethodMapping {
        private Class componentClass;
        private Class methodArgumentType;
        private String methodName;
        private boolean shouldFail;

        public ComponentMethodMapping(Class componentClass, String methodName, Class methodArgumentType) {
            this(componentClass, methodName, methodArgumentType, false);
        }

        public ComponentMethodMapping(Class componentClass, String methodName, Class methodArgumentType, boolean shouldFail) {
            this.componentClass = componentClass;
            this.methodName = methodName;
            this.methodArgumentType = methodArgumentType;
            this.shouldFail = shouldFail;
        }

        public Class getComponentClass() {
            return this.componentClass;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class getMethodArgumentType() {
            return this.methodArgumentType;
        }

        public boolean isShouldFail() {
            return this.shouldFail;
        }

        public String toString() {
            return this.componentClass.getName() + "." + this.methodName + "(" + this.methodArgumentType.getName() + "), Expected to fail= " + this.shouldFail;
        }
    }
}

