/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.context;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.JmxAp;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JmxContext
implements Serializable {
    protected Log logger = LogFactory.getLog(this.getClass());
    private static final long serialVersionUID = -9159123017384356614L;
    protected String name = null;
    protected String server = null;
    protected String domain = null;
    protected String jmxUrl = null;
    protected JmxAp jmxap = null;
    protected Set<ObjectName> onames = null;
    protected String cmdid = null;
    protected boolean adminNaming = true;
    private boolean started = false;
    private boolean successfull = false;
    private boolean interrupted = false;
    private long interruptionTime;
    private static final long MINUTE = 60000L;
    private static final long LOG_PERIOD = 600000L;

    public boolean isAdminNaming() {
        return this.adminNaming;
    }

    public void setAdminNaming(boolean adminNaming) {
        this.adminNaming = adminNaming;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServer() {
        if (this.isAdminNaming()) {
            return this.name;
        }
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getJmxUrl() {
        return this.jmxUrl;
    }

    public void setJmxUrl(String jmxUrl) {
        this.jmxUrl = jmxUrl;
    }

    public JmxAp getJmxap() {
        return this.jmxap;
    }

    public void setJmxap(JmxAp jmxap) {
        this.jmxap = jmxap;
    }

    public String getCmdId() {
        return this.cmdid;
    }

    public void setCmdId(String c) {
        this.cmdid = c;
    }

    public Set<ObjectName> getOnames() {
        return this.onames;
    }

    public void setOnames(Set<ObjectName> onames) {
        this.onames = onames;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.jmxap.getMBeanServerConnection();
    }

    public void updateOnames(String onPattern) throws Exception {
        Set<ObjectName> onSet = this.getObjectNames(onPattern);
        this.setOnames(onSet);
    }

    public void updateOnames(ObjectName onPattern) throws Exception {
        Set<ObjectName> onSet = this.getObjectNames(onPattern);
        if (this.onames == null) {
            this.setOnames(onSet);
        } else {
            for (ObjectName on : onSet) {
                this.onames.add(on);
            }
        }
    }

    public Set<ObjectName> getObjectNames(String onPattern) throws Exception {
        ObjectName on;
        MBeanServerConnection cnx = this.getMBeanServerConnection();
        Set<ObjectName> onSet = null;
        if (onPattern != null) {
            on = null;
            try {
                on = ObjectName.getInstance(onPattern);
            }
            catch (MalformedObjectNameException me) {
                this.logger.error("MBean discovery: failed probe on target {0} because of erroneous ObjectName: {1}, caught exception with message: {2}", this.getName(), onPattern, me.getMessage());
                throw me;
            }
        } else {
            return new HashSet<ObjectName>();
        }
        onSet = this.getObjectNames(on);
        return onSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<ObjectName> getObjectNames(ObjectName onPattern) throws Exception {
        MBeanServerConnection cnx = this.getMBeanServerConnection();
        Set onSet = null;
        if (onPattern == null) return new HashSet<ObjectName>();
        try {
            onSet = cnx.queryNames(onPattern, null);
            if (onSet.isEmpty()) {
                this.successfull = false;
            } else if (!this.successfull) {
                this.logger.debug("MBean discovery successful for target {0} and pattern {1}", this.getName(), onPattern.toString());
                this.setUpManagentInfos();
                this.successfull = true;
            } else {
                this.logger.debug("MBean discovery successful for target {0} and pattern {1}", this.getName(), onPattern.toString());
            }
            if (!this.interrupted || !this.isStarted()) return onSet;
            this.interrupted = false;
            this.logger.info("MBean discovery successful for target {0} and pattern {1}", this.getName(), onPattern.toString());
            this.setUpManagentInfos();
            return onSet;
        }
        catch (IOException e) {
            if (!this.interrupted) {
                this.resetInterruptionTime();
                this.interrupted = true;
                this.logger.error("MBean discovery: failed probe on target {0}, caught exception with message: {1}", this.getName(), e.getMessage());
                throw e;
            } else {
                boolean deltaElapsed = this.isDeltaTimeElapsed();
                if (!deltaElapsed) throw e;
                this.logger.error("MBean discovery: failed probe on target {0}, caught exception with message: {1}", this.getName(), e.getMessage());
                this.resetInterruptionTime();
            }
            throw e;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public void setUpManagentInfos() {
        MBeanServerConnection cnx = this.getMBeanServerConnection();
        ObjectName jvmOnPattern = null;
        try {
            jvmOnPattern = ObjectName.getInstance("*:j2eeType=JVM,*");
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            return;
        }
        Set jvmOns = null;
        try {
            jvmOns = cnx.queryNames(jvmOnPattern, null);
        }
        catch (IOException ioe) {
            return;
        }
        if (jvmOns.isEmpty()) {
            return;
        }
        ObjectName jvmOn = (ObjectName)jvmOns.iterator().next();
        this.setServer(jvmOn.getKeyProperty("J2EEServer"));
        this.setDomain(jvmOn.getDomain());
        this.logger.debug("JmxContext management info was updated with server name: {0}, and domain name : {1}", this.getServer(), this.getDomain());
    }

    private void resetInterruptionTime() {
        this.interruptionTime = System.currentTimeMillis();
    }

    private boolean isDeltaTimeElapsed() {
        long deltaTime = System.currentTimeMillis() - this.interruptionTime;
        return deltaTime > 600000L;
    }
}

