/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.model;

import junit.framework.Assert;
import org.mule.config.PoolingProfile;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.model.seda.SedaModel;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.model.UMOPoolFactory;
import org.mule.util.ExceptionUtils;
import org.mule.util.ObjectPool;

public abstract class AbstractPoolTestCase
extends AbstractMuleTestCase {
    public static final byte FAIL_WHEN_EXHAUSTED = 0;
    public static final byte GROW_WHEN_EXHAUSTED = 1;
    public static final byte BLOCK_WHEN_EXHAUSTED = 2;
    public static final byte DEFAULT_POOL_SIZE = 3;
    public static final long DEFAULT_WAIT = 1500L;

    protected void doSetUp() throws Exception {
        AbstractPoolTestCase.getManager(true);
    }

    public void testCreatePool() throws Exception {
        MuleDescriptor d = AbstractPoolTestCase.getTestDescriptor("orange", Orange.class.getName());
        ObjectPool pool = this.createPool(d, (byte)0);
        AbstractPoolTestCase.assertNotNull(pool);
        AbstractPoolTestCase.assertEquals(0, pool.getSize());
        Object borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertNotNull(borrowed);
        AbstractPoolTestCase.assertEquals(1, pool.getSize());
        pool.returnObject(borrowed);
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertNotNull(borrowed);
        AbstractPoolTestCase.assertEquals(1, pool.getSize());
        Object borrowed2 = pool.borrowObject();
        AbstractPoolTestCase.assertNotNull(borrowed2);
        AbstractPoolTestCase.assertEquals(2, pool.getSize());
    }

    public void testFailOnExhaust() throws Exception {
        ObjectPool pool = this.createPool(AbstractPoolTestCase.getTestDescriptor("orange", Orange.class.getName()), (byte)0);
        Object borrowed = null;
        for (int i = 0; i < pool.getMaxSize(); ++i) {
            borrowed = pool.borrowObject();
            AbstractPoolTestCase.assertNotNull(borrowed);
            AbstractPoolTestCase.assertEquals(pool.getSize(), i + 1);
        }
        try {
            borrowed = pool.borrowObject();
            AbstractPoolTestCase.fail("Should have thrown an Exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testBlockExpiryOnExhaust() throws Exception {
        ObjectPool pool = this.createPool(AbstractPoolTestCase.getTestDescriptor("orange", Orange.class.getName()), (byte)2);
        Object borrowed = null;
        AbstractPoolTestCase.assertEquals(0, pool.getSize());
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertNotNull(borrowed);
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertNotNull(borrowed);
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertNotNull(borrowed);
        AbstractPoolTestCase.assertEquals(3, pool.getSize());
        try {
            borrowed = pool.borrowObject();
            AbstractPoolTestCase.fail("Should have thrown an Exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testBlockOnExhaust() throws Exception {
        ObjectPool pool = this.createPool(AbstractPoolTestCase.getTestDescriptor("orange", Orange.class.getName()), (byte)2);
        Object borrowed = null;
        AbstractPoolTestCase.assertEquals(0, pool.getSize());
        borrowed = pool.borrowObject();
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertEquals(2, pool.getSize());
        long borrowerWait = 500L;
        Borrower borrower = new Borrower(pool, borrowerWait);
        borrower.start();
        Thread.sleep(200L);
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertNotNull(borrowed);
    }

    public void testGrowOnExhaust() throws Exception {
        ObjectPool pool = this.createPool(AbstractPoolTestCase.getTestDescriptor("orange", Orange.class.getName()), (byte)1);
        Object borrowed = pool.borrowObject();
        borrowed = pool.borrowObject();
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertEquals(3, pool.getSize());
        AbstractPoolTestCase.assertEquals(3, pool.getMaxSize());
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertNotNull(borrowed);
        AbstractPoolTestCase.assertEquals(4, pool.getSize());
    }

    public void testClearPool() throws Exception {
        ObjectPool pool = this.createPool(AbstractPoolTestCase.getTestDescriptor("orange", Orange.class.getName()), (byte)0);
        Object borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertEquals(1, pool.getSize());
        pool.returnObject(borrowed);
        pool.clearPool();
        AbstractPoolTestCase.assertEquals(0, pool.getSize());
        borrowed = pool.borrowObject();
        AbstractPoolTestCase.assertEquals(1, pool.getSize());
    }

    public void testCreateFromFactory() throws Exception {
        MuleDescriptor descriptor = AbstractPoolTestCase.getTestDescriptor("orange", Orange.class.getName());
        UMOPoolFactory factory = this.getPoolFactory();
        ObjectPool pool = factory.createPool(descriptor, new SedaModel(), new PoolingProfile());
        AbstractPoolTestCase.assertNotNull(pool);
    }

    public void testPoolLifecycle() throws Exception {
        MuleDescriptor d = AbstractPoolTestCase.getTestDescriptor("orange", Orange.class.getName());
        ObjectPool pool = this.createPool(d, (byte)0);
        AbstractPoolTestCase.assertNotNull(pool);
        AbstractPoolTestCase.assertEquals(0, pool.getSize());
    }

    public abstract ObjectPool createPool(MuleDescriptor var1, byte var2) throws InitialisationException;

    public abstract UMOPoolFactory getPoolFactory();

    private class Borrower
    extends Thread {
        private ObjectPool pool;
        private long time;

        public Borrower(ObjectPool pool, long time) {
            super("Borrower");
            if (pool == null) {
                throw new IllegalArgumentException("Pool cannot be null");
            }
            this.pool = pool;
            if (time < 500L) {
                time = 500L;
            }
            this.time = time;
        }

        public void run() {
            try {
                Object object = this.pool.borrowObject();
                Borrower.sleep(this.time);
                this.pool.returnObject(object);
            }
            catch (Exception e) {
                Assert.fail("Borrower thread failed:\n" + ExceptionUtils.getStackTrace(e));
            }
        }
    }
}

