/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxAp;
import org.ow2.jasmine.monitoring.mbeancmd.JmxHelper;

public class MLoad
extends AbstractCommand {
    private Options options = null;
    private CommandLine commandLine = null;
    private ObjectName mleton = null;
    private static final String MLET_OBJECTNAME_RADIX = "type=jonasmlet";
    private String mletName = null;
    private URL mbeanUrl = null;
    private MBeanServerConnection mbscnx = null;
    private String domain = null;
    private String server = null;
    private JmxAp jmxap = null;

    public MLoad() {
        this.setOptions();
    }

    private void setOptions() {
        this.options = new Options();
        OptionGroup group = new OptionGroup();
        group.setRequired(true);
        Option url = new Option("url", "url", true, "Load mbeans from the URL");
        url.setRequired(false);
        url.setArgName("URL");
        url.setArgs(1);
        group.addOption(url);
        Option query = new Option("q", "query", false, "Query the MLet");
        query.setRequired(false);
        group.addOption(query);
        Option delete = new Option("d", "delete", false, "Delete the MLet");
        delete.setRequired(false);
        group.addOption(delete);
        this.options.addOptionGroup(group);
        Option mlet = new Option("m", "mlet", true, "MLet name");
        mlet.setRequired(false);
        mlet.setArgName("name");
        mlet.setArgs(1);
        this.options.addOption(mlet);
    }

    public int exec(CommandDispatcher cmdDispatcher) {
        try {
            this.parseCommandLine(this.arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        String[] targets = JmxHelper.getJmxTargets(this.commandLine.getOptionValues("target"));
        if (targets == null && JmxHelper.getDefaultJmxTarget() == null) {
            String message = "Target not found";
            this.logger.error(message, new Object[0]);
            cmdDispatcher.setFailed(message);
            return 2;
        }
        this.jmxap = new JmxAp(cmdDispatcher);
        if (this.commandLine.hasOption("q")) {
            try {
                Set son = this.findMletON();
                Iterator it = son.iterator();
                while (it.hasNext()) {
                    System.out.println(it.next());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return 2;
            }
        }
        if (this.commandLine.hasOption("url")) {
            try {
                this.getMletON();
                Set ois = this.LoadMBeans();
                for (Object o : ois) {
                    if (o instanceof ObjectInstance) {
                        ObjectInstance oi = (ObjectInstance)o;
                        System.out.println(oi);
                    }
                    if (!(o instanceof Throwable)) continue;
                    Throwable t = (Throwable)o;
                    System.err.println(t.getMessage());
                    t.printStackTrace(System.err);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return 3;
            }
        }
        if (this.commandLine.hasOption("d")) {
            try {
                this.deleteMLet();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 4;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set LoadMBeans() throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Set ois = null;
        String operation = "getMBeansFromURL";
        Object[] params = new Object[]{this.mbeanUrl};
        String[] sig = new String[]{"java.net.URL"};
        try {
            this.mbscnx = this.jmxap.getMBeanServerConnection();
            ois = (Set)this.mbscnx.invoke(this.mleton, operation, params, sig);
        }
        finally {
            this.jmxap.releaseMBeanServerConnection();
        }
        return ois;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMLet() throws InstanceNotFoundException, MBeanRegistrationException, MalformedObjectNameException, IOException {
        try {
            this.mbscnx = this.jmxap.getMBeanServerConnection();
            this.mbscnx.unregisterMBean(ObjectName.getInstance(this.getDomain() + ":" + MLET_OBJECTNAME_RADIX + ",name=" + (this.mletName != null ? this.mletName : this.server)));
        }
        finally {
            this.jmxap.releaseMBeanServerConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectName getMletON() throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException, MBeanException, IOException {
        if (!this.isMletON()) {
            try {
                this.mbscnx = this.jmxap.getMBeanServerConnection();
                ObjectInstance oi = this.mbscnx.createMBean("javax.management.loading.MLet", ObjectName.getInstance(this.getDomain() + ":" + MLET_OBJECTNAME_RADIX + ",name=" + (this.mletName != null ? this.mletName : this.server)));
                this.mleton = oi.getObjectName();
            }
            finally {
                this.jmxap.releaseMBeanServerConnection();
            }
        }
        return this.mleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMletON() throws IOException, MalformedObjectNameException {
        if (this.mleton == null) {
            Set son;
            ObjectName on = ObjectName.getInstance("*:type=jonasmlet,*");
            try {
                this.mbscnx = this.jmxap.getMBeanServerConnection();
                son = this.mbscnx.queryNames(on, null);
            }
            finally {
                this.jmxap.releaseMBeanServerConnection();
            }
            if (!son.isEmpty()) {
                this.mleton = (ObjectName)son.iterator().next();
            }
        }
        return this.mleton != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set findMletON() throws IOException, MalformedObjectNameException {
        ObjectName on = ObjectName.getInstance("*:type=jonasmlet,*");
        try {
            this.mbscnx = this.jmxap.getMBeanServerConnection();
            Set set = this.mbscnx.queryNames(on, null);
            return set;
        }
        finally {
            this.jmxap.releaseMBeanServerConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDomain() throws IOException, MalformedObjectNameException {
        if (this.domain == null) {
            this.server = null;
            ObjectName j2eeinstance = ObjectName.getInstance("*:j2eeType=J2EEServer,*");
            try {
                this.mbscnx = this.jmxap.getMBeanServerConnection();
                Iterator onames = this.mbscnx.queryNames(j2eeinstance, null).iterator();
                while (this.server == null) {
                    ObjectName j2eeserver = (ObjectName)onames.next();
                    this.server = (String)this.mbscnx.getAttribute(j2eeserver, "serverName");
                    this.domain = j2eeserver.getDomain();
                }
            }
            catch (Exception e) {
                this.server = "unknown_server_name";
                this.domain = "unknown_domain";
            }
            finally {
                this.jmxap.releaseMBeanServerConnection();
            }
        }
        return this.domain;
    }

    private void parseCommandLine(String[] args) throws ParseException, MalformedObjectNameException, MalformedURLException {
        BasicParser bp = new BasicParser();
        this.commandLine = bp.parse(this.options, args);
        if (this.commandLine.hasOption("m")) {
            this.mletName = this.commandLine.getOptionValue("m");
        }
        if (this.commandLine.hasOption("url")) {
            String surl = this.commandLine.getOptionValue("url");
            this.mbeanUrl = new URL(surl);
        }
    }

    public String summary() {
        return "MBean loading utility";
    }
}

