/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxAp;
import org.ow2.jasmine.monitoring.mbeancmd.JmxHelper;
import org.ow2.jasmine.monitoring.mbeancmd.Outer;
import org.ow2.jasmine.monitoring.mbeancmd.commands.HeaderAtt;
import org.ow2.jasmine.monitoring.mbeancmd.commands.StatMBeanResult;
import org.ow2.jasmine.monitoring.mbeancmd.context.StatContext;
import org.ow2.jasmine.monitoring.mbeancmd.graph.Grapher;
import org.ow2.jasmine.monitoring.mbeancmd.graph.conf.Configurator;
import org.ow2.jasmine.monitoring.mbeancmd.jasmine.JasmineConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stat
extends AbstractCommand {
    protected boolean goOn;
    private StatContext[] contexts = null;
    private Options options = null;
    private CommandLine commandLine = null;
    private ObjectName objectName = null;
    private long period = 10L;
    private long refreshPeriod = 300L;
    private boolean isRefreshable = true;
    private String graphDef = null;
    private String cmdid = null;
    private String outputFilePath = null;
    private String jasmineURI = null;
    private PrintStream pout = null;
    private boolean isConsoleOption = false;
    private String separator = ";";
    private String header = null;
    private CommandDispatcher cmdDispatcher = null;
    private long warningTrigger = 0L;
    private boolean aOption = false;
    private boolean allOption = false;
    private boolean rateOption = false;
    private boolean deltaOption = false;
    private boolean slopeOption = false;
    private boolean oldValues = false;
    private String[] attsSimple = null;
    private Map<String, List<String>> multiAttsSimple = new HashMap<String, List<String>>();
    private List<StatMBeanResult> results = new ArrayList<StatMBeanResult>();
    private List<StatMBeanResult> resultsComplete = null;
    List<HeaderAtt> hatts = new ArrayList<HeaderAtt>();
    private String[] nameArgs = null;
    private Map<String, String> aliases = new HashMap<String, String>();
    private String[] attsRate = null;
    private String[] attsDelta = null;
    private String[] attsSlope = null;
    private List<String> attsRateDelatSlope = null;
    private List<String> attsTotal = new ArrayList<String>();
    private List<Outer> outers = new ArrayList<Outer>();
    private int numberDecimalPlaces = 16;
    private static final String PREFIX_RATE = "rate_";
    private static final String PREFIX_DELTA = "delta_";
    private static final String INFIX_SLOPE = "_per_";

    public Stat() {
        this.setOptions();
    }

    public static void main(String[] args) {
        Stat p = new Stat();
        p.setArgs("stat", args);
        p.exec(null);
    }

    @Override
    public void stop() {
        this.goOn = false;
    }

    @Override
    public int exec(CommandDispatcher cmdDispatcher) {
        this.cmdDispatcher = cmdDispatcher;
        try {
            this.parseCommandLine(this.arguments);
        }
        catch (Exception e) {
            System.out.println("Options format exception in stat command : " + e.getMessage());
            cmdDispatcher.setFailed(e.getMessage());
            return 1;
        }
        PipedOutputStream out = new PipedOutputStream();
        this.pout = new PrintStream(out);
        Outer outer = null;
        try {
            if (this.isConsoleOption) {
                outer = new Outer(out);
                this.outers.add(outer);
            }
            if (this.outputFilePath != null) {
                if (outer == null) {
                    outer = new Outer(out, new File(this.outputFilePath));
                    this.outers.add(outer);
                } else {
                    Outer consoleOuter = outer;
                    PipedOutputStream sink = new PipedOutputStream();
                    consoleOuter.setSink(sink);
                    outer = new Outer(sink, new File(this.outputFilePath));
                    this.outers.add(outer);
                    new Thread(consoleOuter).start();
                }
            } else if (this.jasmineURI == null && outer == null) {
                outer = new Outer(out);
                this.outers.add(outer);
            }
            if (this.jasmineURI != null) {
                if (outer == null) {
                    outer = JasmineConnector.connect(out, this.jasmineURI);
                } else {
                    Outer oldOuter = outer;
                    outer = JasmineConnector.connect(outer, this.jasmineURI);
                    new Thread(oldOuter).start();
                }
                this.outers.add(outer);
            }
        }
        catch (IOException e) {
            this.logger.error("Cannot set up file or jasmine output :  {0}", e.getMessage(), e);
        }
        if (this.graphDef != null) {
            try {
                PipedOutputStream sink = new PipedOutputStream();
                outer.setSink(sink);
                Grapher gr = new Grapher(sink, this.graphDef);
                gr.start();
            }
            catch (IOException e) {
                this.logger.error("Cannot set up graph output :  {0}", e.getMessage(), e);
            }
        }
        new Thread(outer).start();
        try {
            this.process();
            cmdDispatcher.setStopped();
        }
        catch (Exception e) {
            cmdDispatcher.setFailed(e.getMessage());
        }
        return 0;
    }

    @Override
    public void help() {
        super.help();
        System.out.println("\nDTD for graph definitions:\n--------------------------\n\n");
        LineNumberReader ln = Configurator.getDTD();
        if (ln != null) {
            try {
                String line = null;
                while ((line = ln.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.logger.error("Error: DTD not found !", new Object[0]);
        }
    }

    @Override
    public String summary() {
        return "Periodically probes MBeans in one or multiple J2EE servers";
    }

    public void parseCommandLine(String[] args) throws ParseException, MalformedObjectNameException {
        BasicParser bp = new BasicParser();
        this.commandLine = bp.parse(this.options, args);
        this.nameArgs = this.commandLine.getOptionValues("name");
        if (this.nameArgs.length == 1) {
            this.setObjectName();
        } else if (this.nameArgs.length > 1) {
            if (!this.getAliases()) {
                throw new ParseException("-name aliases format exception");
            }
            for (String mbeanName : this.aliases.values()) {
                ObjectName on = ObjectName.getInstance(mbeanName);
            }
        } else {
            throw new ParseException("-name option is empty");
        }
        if (this.commandLine.hasOption("p")) {
            this.setPeriod();
        }
        if (this.commandLine.hasOption("r")) {
            this.setRefreshPeriod();
        }
        if (this.commandLine.hasOption("cmdid")) {
            this.cmdid = this.commandLine.getOptionValue("cmdid");
        }
        if (this.commandLine.hasOption("graph")) {
            this.graphDef = this.commandLine.getOptionValue("graph");
        }
        if (this.commandLine.hasOption("f")) {
            this.outputFilePath = this.commandLine.getOptionValue("f");
        }
        if (this.commandLine.hasOption("jasmine")) {
            this.jasmineURI = this.commandLine.getOptionValue("jasmine");
        }
        this.isConsoleOption = this.commandLine.hasOption("console");
        if (this.commandLine.hasOption("s")) {
            this.separator = this.commandLine.getOptionValue("s");
            Outer.setSeparator(this.separator);
        }
        if (this.commandLine.hasOption("rate")) {
            this.rateOption = true;
            this.attsRate = this.commandLine.getOptionValues("rate");
            if (this.aliases()) {
                this.logger.warn("-rate option is ignored because aliases are defined", new Object[0]);
            }
        }
        if (this.commandLine.hasOption("delta")) {
            this.deltaOption = true;
            this.attsDelta = this.commandLine.getOptionValues("delta");
            if (this.aliases()) {
                this.logger.warn("-delta option is ignored because aliases are defined", new Object[0]);
            }
        }
        if (this.commandLine.hasOption("slope")) {
            this.slopeOption = true;
            String[] slopeOptionValues = this.commandLine.getOptionValues("slope");
            if (slopeOptionValues.length % 2 != 0) {
                throw new MalformedObjectNameException("Command failed at: slope option. Number of attributes should be pair.");
            }
            this.attsSlope = slopeOptionValues;
            if (this.aliases()) {
                this.logger.warn("-slope option is ignored because aliases are defined", new Object[0]);
            }
        }
        if (this.commandLine.hasOption("a")) {
            this.attsSimple = this.commandLine.getOptionValues("a");
            if (this.attsSimple != null) {
                this.aOption = true;
                if (this.aliases() && !this.getMultiAttsSimple()) {
                    throw new ParseException("-a aliase:attName format exception");
                }
            } else {
                this.allOption = true;
            }
        } else if (!(this.deltaOption || this.rateOption || this.slopeOption)) {
            this.allOption = true;
        }
        if (this.deltaOption || this.rateOption || this.slopeOption) {
            this.oldValues = true;
            this.attsRateDelatSlope = new ArrayList<String>();
            if (this.attsRate != null) {
                for (String att : this.attsRate) {
                    if (this.attsRateDelatSlope.contains(att)) continue;
                    this.attsRateDelatSlope.add(att);
                }
            }
            if (this.attsDelta != null) {
                for (String att : this.attsDelta) {
                    if (this.attsRateDelatSlope.contains(att)) continue;
                    this.attsRateDelatSlope.add(att);
                }
            }
            if (this.attsSlope != null) {
                for (String att : this.attsSlope) {
                    if (this.attsRateDelatSlope.contains(att)) continue;
                    this.attsRateDelatSlope.add(att);
                }
            }
        }
        if (!this.allOption && !this.aliases()) {
            if (this.aOption) {
                for (int i = 0; i < this.attsSimple.length; ++i) {
                    this.attsTotal.add(this.attsSimple[i]);
                }
            }
            if (this.oldValues) {
                for (String att : this.attsRateDelatSlope) {
                    if (this.attsTotal.contains(att)) continue;
                    this.attsTotal.add(att);
                }
            }
        }
    }

    private boolean getMultiAttsSimple() {
        for (String aliasAtt : this.attsSimple) {
            if (",".equals(aliasAtt)) continue;
            if (!aliasAtt.contains(":") || aliasAtt.indexOf(":") == aliasAtt.length() - 1) {
                this.logger.error("-a argument must have format alias:attName", new Object[0]);
                return false;
            }
            String alias = aliasAtt.substring(0, aliasAtt.indexOf(":"));
            String attName = aliasAtt.substring(aliasAtt.indexOf(":") + 1, aliasAtt.length());
            if (!this.aliases.containsKey(alias)) {
                this.logger.error("-a argument must have format alias:attName but no alias {0} exists ", alias);
                return false;
            }
            if (attName.endsWith(",")) {
                attName = attName.substring(0, attName.length() - 1);
            }
            this.logger.debug("attribut alias : {0} for name {1}", alias, attName);
            String mbeanNamePattern = this.aliases.get(alias);
            if (!this.multiAttsSimple.containsKey(mbeanNamePattern)) {
                this.multiAttsSimple.put(mbeanNamePattern, new ArrayList());
                this.multiAttsSimple.get(mbeanNamePattern).add(alias);
            }
            this.multiAttsSimple.get(mbeanNamePattern).add(attName);
        }
        return true;
    }

    private boolean getAliases() {
        int i = 0;
        while (i < this.nameArgs.length) {
            String mbeanName = this.nameArgs[i];
            if (",".equals(mbeanName)) {
                ++i;
                continue;
            }
            try {
                String as = this.nameArgs[i + 1];
                if (!"as".equals(as)) {
                    return false;
                }
                String alias = this.nameArgs[i + 2];
                if (alias.endsWith(",")) {
                    alias = alias.substring(0, alias.length() - 1);
                }
                if (this.aliases.containsKey(alias)) {
                    this.logger.error("-name arguments must contain distinct aliases", new Object[0]);
                    return false;
                }
                if (this.aliases.containsValue(mbeanName)) {
                    this.logger.error("-name arguments must contain distinct mbean names", new Object[0]);
                    return false;
                }
                this.logger.debug("Got alias {0} for mbean name {1}", alias, mbeanName);
                this.aliases.put(alias, mbeanName);
            }
            catch (IndexOutOfBoundsException iobe) {
                this.logger.error("-name arguments count must contain triplets (mbeanName as alias)", new Object[0]);
                return false;
            }
            i += 3;
        }
        return true;
    }

    private void setObjectName() throws MalformedObjectNameException {
        String mbean = this.commandLine.getOptionValue("name");
        if (mbean.contains("\"")) {
            StringBuffer quotedMbean = new StringBuffer();
            StringTokenizer st = new StringTokenizer(mbean, "\"");
            quotedMbean.append(st.nextToken());
            while (st.hasMoreTokens()) {
                quotedMbean.append(ObjectName.quote(st.nextToken()));
                if (!st.hasMoreTokens()) continue;
                quotedMbean.append(st.nextToken());
            }
            this.objectName = new ObjectName(quotedMbean.toString());
        } else {
            this.objectName = new ObjectName(mbean);
        }
    }

    private void setPeriod() throws NumberFormatException {
        this.period = Long.parseLong(this.commandLine.getOptionValue("p"));
    }

    private void setRefreshPeriod() throws NumberFormatException {
        String val = this.commandLine.getOptionValue("r");
        if ("never".equalsIgnoreCase(val)) {
            this.isRefreshable = false;
        } else {
            this.refreshPeriod = Long.parseLong(val);
        }
    }

    private void mbeanPoll() throws Exception {
        this.goOn = this.contexts != null;
        boolean refreshNow = false;
        while (this.goOn) {
            for (int i = 0; i < this.contexts.length; ++i) {
                StatContext context = this.contexts[i];
                MBeanServerConnection cnx = context.getJmxap().getMBeanServerConnection();
                long now = System.currentTimeMillis();
                boolean bl = refreshNow = this.isRefreshable && now >= context.getRefreshDeadLine();
                if (refreshNow) {
                    if (this.objectName != null) {
                        context.updateOnames(this.objectName);
                    } else {
                        for (String mbeanName : this.aliases.values()) {
                            context.updateOnames(ObjectName.getInstance(mbeanName));
                        }
                    }
                    context.setRefreshDeadLine(now + this.refreshPeriod * 1000L);
                }
                Iterator<ObjectName> it = context.getOnames().iterator();
                int nbOns = context.getOnames().size();
                boolean itCounter = false;
                while (it.hasNext()) {
                    long t = System.currentTimeMillis();
                    ObjectName onGot = it.next();
                    try {
                        AttributeList attl = new AttributeList();
                        if (this.aliases()) {
                            List<String> atts = null;
                            String key = null;
                            if (this.multiAttsSimple.containsKey(onGot.toString())) {
                                key = onGot.toString();
                                atts = this.multiAttsSimple.get(key);
                            } else {
                                for (String onPattern : this.multiAttsSimple.keySet()) {
                                    ObjectName on = ObjectName.getInstance(onPattern);
                                    Set<ObjectName> ons = context.getObjectNames(on);
                                    if (!ons.contains(onGot)) continue;
                                    key = onPattern;
                                    atts = this.multiAttsSimple.get(key);
                                    break;
                                }
                            }
                            if (atts == null) {
                                this.logger.warn("Could not determine attributes to poll for MBean {0} (or no attributes defined by the -a option for this MBean).", onGot.toString());
                            } else {
                                ArrayList<String> copyAtts = new ArrayList<String>(atts);
                                String currentAlias = atts.remove(0);
                                AttributeList attList = this.getAttributeValues(cnx, onGot, context.getName(), atts.toArray(new String[atts.size()]));
                                this.multiAttsSimple.put(key, copyAtts);
                                StatMBeanResult res = new StatMBeanResult(currentAlias, onGot, attList);
                                if (this.results != null) {
                                    this.results.add(res);
                                    if (this.results.size() == nbOns) {
                                        this.resultsComplete = this.results;
                                        this.results = null;
                                    }
                                }
                                this.printMBeanPollMulti(t, context, attl, onGot, res);
                            }
                        } else {
                            HashMap<String, Object> currentValues = this.getAttributeValues(cnx, onGot, context.getName());
                            if (this.aOption) {
                                for (int j = 0; j < this.attsSimple.length; ++j) {
                                    Attribute attribute = new Attribute(this.attsSimple[j], currentValues.get(this.attsSimple[j]));
                                    attl.add(attribute);
                                }
                            }
                            if (this.rateOption) {
                                try {
                                    AttributeList attributesRate = this.getAttributesRate(context, onGot, this.attsRate, currentValues);
                                    attl.addAll(attributesRate);
                                }
                                catch (MalformedObjectNameException ex) {
                                    ex.printStackTrace();
                                    throw ex;
                                }
                            }
                            if (this.deltaOption) {
                                try {
                                    AttributeList attributesDelta = this.getAttributesDelta(context, onGot, this.attsDelta, currentValues);
                                    attl.addAll(attributesDelta);
                                }
                                catch (MalformedObjectNameException ex) {
                                    ex.printStackTrace();
                                    throw ex;
                                }
                            }
                            if (this.slopeOption) {
                                try {
                                    AttributeList attributesSlope = this.getAttributesSlope(context, onGot, this.attsSlope, currentValues);
                                    attl.addAll(attributesSlope);
                                }
                                catch (MalformedObjectNameException ex) {
                                    ex.printStackTrace();
                                    throw ex;
                                }
                            }
                            if (this.allOption) {
                                for (String attName : this.attsTotal) {
                                    Object attValue = currentValues.get(attName);
                                    Attribute attribute = new Attribute(attName, attValue);
                                    attl.add(attribute);
                                }
                            }
                            if (this.oldValues) {
                                this.updateOldValues(onGot, context, currentValues);
                            }
                            currentValues = null;
                            this.printMBeanPoll(t, context, attl, onGot);
                        }
                        if (context.isStarted()) continue;
                        context.setStarted(true);
                    }
                    catch (Exception e) {
                        this.logger.error("Error on mbean {0} for {1} - {2}", onGot, context.getName(), e.getMessage());
                        throw e;
                    }
                }
            }
            try {
                Thread.sleep(this.period * 1000L);
            }
            catch (InterruptedException e) {
                this.goOn = false;
            }
        }
        for (Outer outer : this.outers) {
            outer.stop();
        }
        this.pout.close();
    }

    private AttributeList getAttributeValues(MBeanServerConnection cnx, ObjectName on, String target, String[] atts) throws IOException, ReflectionException, InstanceNotFoundException, AttributeNotFoundException, MBeanException {
        try {
            return cnx.getAttributes(on, atts);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (this.warningTrigger % (86400L / this.period) == 0L) {
                this.logger.warn("MBeanCmd stat : cannot get attributes in one shot, trying one by one ({0}) for {1}", on, target);
                ++this.warningTrigger;
            }
            AttributeList result = new AttributeList();
            for (String attName : atts) {
                Object attValue = cnx.getAttribute(on, attName);
                Attribute att = new Attribute(attName, attValue);
                result.add(att);
            }
            return result;
        }
    }

    private HashMap<String, Object> getAttributeValues(MBeanServerConnection cnx, ObjectName on, String target) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IntrospectionException, IOException {
        if (this.attsTotal.isEmpty()) {
            ArrayList<String> allAttsName = new ArrayList<String>();
            try {
                MBeanInfo infos = cnx.getMBeanInfo(on);
                MBeanAttributeInfo[] attInfos = infos.getAttributes();
                for (int i = 0; i < attInfos.length; ++i) {
                    MBeanAttributeInfo attInfo = attInfos[i];
                    String attName = attInfo.getName();
                    allAttsName.add(attName);
                }
            }
            catch (InstanceNotFoundException e) {
                this.logger.info("Cannot get info about the {0} MBean in target {1}", on, target);
                throw e;
            }
            catch (IntrospectionException e) {
                this.logger.info("Cannot get info about the {0} MBean in target {1}", on, target);
                throw e;
            }
            catch (ReflectionException e) {
                this.logger.info("Cannot get info about the {0} MBean in target {1}", on, target);
                throw e;
            }
            catch (IOException e) {
                this.logger.info("Cannot get info about the {0} MBean in target {1}", on, target);
                throw e;
            }
            this.attsTotal = allAttsName;
            this.logger.info("Attributes list to poll was constructed using the {0} MBean in target {1}", on, target);
        }
        HashMap<String, Object> newValueOfAttributes = new HashMap<String, Object>();
        AttributeList attributes = this.getAttributeValues(cnx, on, target, Stat.toArray(this.attsTotal));
        for (Attribute attribute : attributes) {
            String attributeName = attribute.getName();
            Object attributeValue = attribute.getValue();
            newValueOfAttributes.put(attributeName, attributeValue);
        }
        return newValueOfAttributes;
    }

    private AttributeList getAttributesRate(StatContext context, ObjectName on, String[] attsRate, HashMap<String, Object> currentValues) throws MalformedObjectNameException {
        AttributeList result = new AttributeList();
        for (int i = 0; i < attsRate.length; ++i) {
            Double value;
            String name;
            boolean hasNumeriqueValue;
            String attName = attsRate[i];
            Object currentValue = currentValues.get(attName);
            boolean bl = hasNumeriqueValue = currentValue instanceof Integer || currentValue instanceof Double || currentValue instanceof Long || currentValue instanceof Float;
            if (hasNumeriqueValue) {
                name = PREFIX_RATE + attsRate[i];
                value = null;
                Object oldValue = context.getOldValue(on, attName);
                if (oldValue != null) {
                    Double dX = new Double(currentValue.toString()) - new Double(oldValue.toString());
                    Double dT = new Double(this.period);
                    value = dT == 0.0 ? Double.valueOf(Double.MAX_VALUE) : Double.valueOf(Stat.floor(dX / dT, this.numberDecimalPlaces));
                }
            } else {
                throw new MalformedObjectNameException("Command failed at: All the attributes of rate option should be numeric. Problem with " + attName + " of MBean " + on.toString());
            }
            Attribute attribute = new Attribute(name, value);
            result.add(attribute);
        }
        return result;
    }

    private void updateOldValues(ObjectName on, StatContext context, HashMap<String, Object> currentValues) {
        for (String attName : this.attsRateDelatSlope) {
            Object currentValue = currentValues.get(attName);
            context.setOldValue(on, attName, currentValue);
        }
    }

    private AttributeList getAttributesDelta(StatContext context, ObjectName on, String[] attsDelta, HashMap<String, Object> currentValues) throws MalformedObjectNameException {
        AttributeList result = new AttributeList();
        for (int i = 0; i < attsDelta.length; ++i) {
            Double dX;
            String name;
            boolean hasNumeriqueValue;
            String attName = attsDelta[i];
            Object currentValue = currentValues.get(attName);
            boolean bl = hasNumeriqueValue = currentValue instanceof Integer || currentValue instanceof Double || currentValue instanceof Long || currentValue instanceof Float;
            if (hasNumeriqueValue) {
                name = PREFIX_DELTA + attsDelta[i];
                Object oldValue = context.getOldValue(on, attName);
                dX = null;
                if (oldValue != null) {
                    dX = new Double(currentValue.toString()) - new Double(oldValue.toString());
                }
            } else {
                throw new MalformedObjectNameException("Command failed at: All the attributes of delta option should be numeric : " + attName + ".");
            }
            Attribute attribute = new Attribute(name, dX);
            result.add(attribute);
        }
        return result;
    }

    private AttributeList getAttributesSlope(StatContext context, ObjectName on, String[] attsSlope, HashMap<String, Object> currentValues) throws MalformedObjectNameException {
        AttributeList result = new AttributeList();
        for (int i = 0; i < attsSlope.length - 1; i += 2) {
            Double value;
            String name;
            boolean hasNumeriqueValue2;
            String attName1 = attsSlope[i];
            String attName2 = attsSlope[i + 1];
            Object currentValue1 = currentValues.get(attName1);
            Object currentValue2 = currentValues.get(attName2);
            boolean hasNumeriqueValue1 = currentValue1 instanceof Integer || currentValue1 instanceof Double || currentValue1 instanceof Long || currentValue1 instanceof Float;
            boolean bl = hasNumeriqueValue2 = currentValue2 instanceof Integer || currentValue2 instanceof Double || currentValue2 instanceof Long || currentValue2 instanceof Float;
            if (hasNumeriqueValue1 && hasNumeriqueValue2) {
                name = attName1 + INFIX_SLOPE + attName2;
                Object oldValue1 = context.getOldValue(on, attName1);
                Object oldValue2 = context.getOldValue(on, attName2);
                value = null;
                if (oldValue1 != null && oldValue2 != null) {
                    Double dX = new Double(currentValue1 + "") - new Double(oldValue1 + "");
                    Double dY = new Double(currentValue2 + "") - new Double(oldValue2 + "");
                    value = dX == 0.0 ? new Double(0.0) : (dY == 0.0 ? Double.valueOf(Double.MAX_VALUE) : Double.valueOf(Stat.floor(dX / dY, this.numberDecimalPlaces)));
                }
            } else {
                if (!hasNumeriqueValue1 && !hasNumeriqueValue2) {
                    throw new MalformedObjectNameException("Command failed at: All the attributes of slope option should be numeric : " + attName1 + "," + attName2 + ".");
                }
                if (!hasNumeriqueValue1) {
                    throw new MalformedObjectNameException("Command failed at: All the attributes of slope option should be numeric : " + attName1 + ".");
                }
                throw new MalformedObjectNameException("Command failed at: All the attributes of slope option should be numeric : " + attName2 + ".");
            }
            Attribute attribute = new Attribute(name, value);
            result.add(attribute);
        }
        return result;
    }

    private String[] getAttsToPoll(StatContext context, ObjectName on) throws IOException {
        String[] atts = null;
        ObjectName onGot = null;
        Iterator it = null;
        try {
            it = context.getMBeanServerConnection().queryNames(on, null).iterator();
        }
        catch (IOException e) {
            this.logger.error("Cannot get MBeans using {0} in target {1}", on.toString(), context.getName());
            throw e;
        }
        while (it.hasNext()) {
            onGot = (ObjectName)it.next();
            try {
                MBeanAttributeInfo[] info = context.getMBeanServerConnection().getMBeanInfo(onGot).getAttributes();
                atts = new String[info.length];
                for (int i = 0; i < atts.length; ++i) {
                    atts[i] = info[i].getName();
                }
                break;
            }
            catch (Exception e) {
                this.logger.error("Cannot get attributes for MBean {0} in target {1}", onGot.toString(), context.getName());
            }
        }
        if (atts == null) {
            this.logger.warn("No attribute found for MBeans using {0} in target {1}", on.toString(), context.getName());
            atts = new String[]{};
        }
        return atts;
    }

    private String getMBeanPollHeader(AttributeList attl) {
        if (this.header == null) {
            String headerBase = this.getHeaderBase();
            StringBuffer buf = new StringBuffer(512);
            Iterator it = attl.iterator();
            while (it.hasNext()) {
                buf.append(this.separator);
                Attribute att = (Attribute)it.next();
                if (att.getValue() != null && att.getValue().getClass().isArray()) {
                    this.putArrayIntoHeader(buf, att);
                    continue;
                }
                if (att.getValue() != null && att.getValue() instanceof Map) {
                    this.putMapIntoHeader(buf, att);
                    continue;
                }
                if (att.getValue() != null && att.getValue() instanceof CompositeData) {
                    this.putCompositeDataIntoHeader(buf, att);
                    continue;
                }
                buf.append(att.getName());
            }
            this.header = headerBase + buf.toString();
        }
        return this.header;
    }

    private String getHeaderBase() {
        StringBuffer buf = new StringBuffer(512);
        buf.append("date");
        buf.append(this.separator);
        buf.append("time");
        buf.append(this.separator);
        buf.append("sname");
        buf.append(this.separator);
        buf.append("server");
        buf.append(this.separator);
        buf.append("domain");
        buf.append(this.separator);
        buf.append("mbean");
        buf.append(this.separator);
        buf.append("cmdid");
        return buf.toString();
    }

    private void putArrayIntoHeader(StringBuffer buf, Attribute att) {
        Object obj = att.getValue();
        int length = Array.getLength(obj);
        for (int i = 0; i < length; ++i) {
            buf.append(i == 0 ? "" : this.separator);
            buf.append(att.getName());
            buf.append("_");
            buf.append(i);
        }
    }

    private void putMapIntoHeader(StringBuffer buf, Attribute att) {
        Map map = (Map)att.getValue();
        TreeSet ts = new TreeSet(map.keySet());
        Iterator it = ts.iterator();
        String sep = "";
        while (it.hasNext()) {
            buf.append(sep);
            sep = this.separator;
            buf.append(att.getName());
            buf.append("_");
            buf.append(it.next());
        }
    }

    private void putCompositeDataIntoHeader(StringBuffer buf, Attribute att) {
        CompositeData cdata = (CompositeData)att.getValue();
        Set itemNames = cdata.getCompositeType().keySet();
        Iterator it = itemNames.iterator();
        String sep = "";
        while (it.hasNext()) {
            buf.append(sep);
            sep = this.separator;
            buf.append(att.getName());
            buf.append("_");
            buf.append(it.next());
        }
    }

    private String getMultiHeader() {
        ArrayList<StatMBeanResult> onceAliasResults = new ArrayList<StatMBeanResult>();
        for (String alias : this.aliases.keySet()) {
            StatMBeanResult currentRes = null;
            for (StatMBeanResult res : this.resultsComplete) {
                if (!res.getAlias().equals(alias)) continue;
                currentRes = res;
                break;
            }
            if (currentRes == null) continue;
            onceAliasResults.add(currentRes);
        }
        for (StatMBeanResult res : onceAliasResults) {
            String alias = res.getAlias();
            AttributeList al = res.getAttl();
            for (int i = 0; i < al.size(); ++i) {
                Iterator<Object> it;
                Attribute a = (Attribute)al.get(i);
                Object val = a.getValue();
                String attName = null;
                if (val != null && val.getClass().isArray()) {
                    int length = Array.getLength(val);
                    for (int j = 0; j < length; ++j) {
                        attName = a.getName() + "_" + j;
                        HeaderAtt ha = new HeaderAtt(alias, attName);
                        this.hatts.add(ha);
                    }
                    continue;
                }
                if (val != null && val instanceof Map) {
                    Map map = (Map)val;
                    TreeSet ts = new TreeSet(map.keySet());
                    it = ts.iterator();
                    while (it.hasNext()) {
                        attName = a.getName() + "_" + it.next();
                        HeaderAtt ha = new HeaderAtt(alias, attName);
                        this.hatts.add(ha);
                    }
                    continue;
                }
                if (val != null && val instanceof CompositeData) {
                    CompositeData cdata = (CompositeData)val;
                    Set itemNames = cdata.getCompositeType().keySet();
                    it = itemNames.iterator();
                    String sep = "";
                    while (it.hasNext()) {
                        attName = a.getName() + "_" + it.next();
                        HeaderAtt ha = new HeaderAtt(alias, attName);
                        this.hatts.add(ha);
                    }
                    continue;
                }
                attName = a.getName();
                HeaderAtt ha = new HeaderAtt(alias, attName);
                this.hatts.add(ha);
            }
        }
        StringBuffer buf = new StringBuffer(512);
        for (HeaderAtt ha : this.hatts) {
            buf.append(this.separator);
            buf.append(ha.getAlias());
            buf.append(":");
            buf.append(ha.getAttName());
        }
        String headerBase = this.getHeaderBase();
        this.header = headerBase + buf.toString();
        return this.header;
    }

    private void printMBeanPollMulti(long t, StatContext context, AttributeList attl, ObjectName oname, StatMBeanResult result) {
        if (this.header == null) {
            if (this.resultsComplete != null) {
                this.pout.println(this.getMultiHeader());
                for (StatMBeanResult res : this.resultsComplete) {
                    this.printResult(t, context, res);
                }
            }
        } else {
            this.printResult(t, context, result);
            this.resultsComplete = null;
        }
    }

    private void printResult(long t, StatContext context, StatMBeanResult res) {
        Object[] vals = new Object[this.hatts.size()];
        int k = 0;
        for (HeaderAtt ha : this.hatts) {
            if (ha.getAlias().equals(res.getAlias())) {
                String attName = ha.getAttName();
                AttributeList al = res.getAttl();
                boolean found = false;
                for (int i = 0; i < al.size(); ++i) {
                    String aNameElem;
                    Object aValueElem;
                    Attribute a = (Attribute)al.get(i);
                    String aName = a.getName();
                    Object aValue = a.getValue();
                    if (aName.equals(attName)) {
                        vals[k] = aValue;
                        found = true;
                        break;
                    }
                    if (aValue != null && aValue.getClass().isArray()) {
                        int length = Array.getLength(aValue);
                        boolean foundInArray = false;
                        for (int j = 0; j < length; ++j) {
                            Object aValueElem2 = Array.get(aValue, j);
                            String aNameElem2 = aName + "_" + j;
                            if (!aNameElem2.equals(attName)) continue;
                            vals[k] = aValueElem2;
                            foundInArray = true;
                            break;
                        }
                        if (!foundInArray) continue;
                        found = true;
                        break;
                    }
                    if (aValue != null && aValue instanceof Map) {
                        boolean foundInMap = false;
                        Map map = (Map)aValue;
                        TreeSet ts = new TreeSet(map.keySet());
                        for (String key : ts) {
                            aValueElem = map.get(key);
                            aNameElem = aName + "_" + key;
                            if (!aNameElem.equals(attName)) continue;
                            vals[k] = aValueElem;
                            foundInMap = true;
                            break;
                        }
                        if (!foundInMap) continue;
                        found = true;
                        break;
                    }
                    if (aValue == null || !(aValue instanceof CompositeData)) continue;
                    boolean foundInComp = false;
                    CompositeData cdata = (CompositeData)aValue;
                    Set itemNames = cdata.getCompositeType().keySet();
                    for (String key : itemNames) {
                        aValueElem = cdata.get(key);
                        aNameElem = aName + "_" + key;
                        if (!aNameElem.equals(attName)) continue;
                        vals[k] = aValueElem;
                        foundInComp = true;
                        break;
                    }
                    if (!foundInComp) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    vals[k] = null;
                }
            } else {
                vals[k] = null;
            }
            ++k;
        }
        Date d = new Date(t);
        this.pout.print(SIMPLEDATEFORMAT.format(d));
        this.pout.print(this.separator);
        this.pout.print(t);
        this.pout.print(this.separator);
        this.pout.print(context.getJmxUrl());
        this.pout.print(this.separator);
        this.pout.print(context.getServer());
        this.pout.print(this.separator);
        this.pout.print(context.getDomain());
        this.pout.print(this.separator);
        this.pout.print(res.getOn());
        this.pout.print(this.separator);
        this.pout.print(this.cmdid);
        for (Object val : vals) {
            this.pout.print(this.separator);
            if (val == null) continue;
            this.pout.print(val);
        }
        this.pout.println();
    }

    private void printMBeanPoll(long t, StatContext context, AttributeList attl, ObjectName oname) {
        if (this.header == null) {
            this.pout.println(this.getMBeanPollHeader(attl));
        }
        Date d = new Date(t);
        this.pout.print(SIMPLEDATEFORMAT.format(d));
        this.pout.print(this.separator);
        this.pout.print(t);
        this.pout.print(this.separator);
        this.pout.print(context.getJmxUrl());
        this.pout.print(this.separator);
        this.pout.print(context.getServer());
        this.pout.print(this.separator);
        this.pout.print(context.getDomain());
        this.pout.print(this.separator);
        this.pout.print(oname);
        this.pout.print(this.separator);
        this.pout.print(this.cmdid);
        Iterator it = attl.iterator();
        while (it.hasNext()) {
            this.pout.print(this.separator);
            Attribute att = (Attribute)it.next();
            if (att.getValue() != null && att.getValue().getClass().isArray()) {
                Object obj = att.getValue();
                int length = Array.getLength(obj);
                for (int i = 0; i < length; ++i) {
                    this.pout.print((i == 0 ? "" : this.separator) + Array.get(obj, i));
                }
                continue;
            }
            if (att.getValue() != null && att.getValue() instanceof Map) {
                Map map = (Map)att.getValue();
                TreeSet ts = new TreeSet(map.keySet());
                String sep = "";
                Iterator it2 = ts.iterator();
                while (it2.hasNext()) {
                    this.pout.print(sep);
                    sep = this.separator;
                    this.pout.print(map.get(it2.next()));
                }
                continue;
            }
            if (att.getValue() != null && att.getValue() instanceof CompositeData) {
                CompositeData cdata = (CompositeData)att.getValue();
                Set itemNames = cdata.getCompositeType().keySet();
                Iterator it2 = itemNames.iterator();
                String sep = "";
                while (it2.hasNext()) {
                    this.pout.print(sep);
                    sep = this.separator;
                    this.pout.print(cdata.get((String)it2.next()));
                }
                continue;
            }
            if (att.getValue() == null) continue;
            this.pout.print(att.getValue());
        }
        this.pout.println();
    }

    private void setOptions() {
        this.options = new Options();
        this.options.addOption("v", "verbose", false, "Verbose mode");
        Option name = new Option("name", "objectName", true, "An ObjectName passed to every method");
        name.setRequired(true);
        name.setArgName("mbean name");
        name.setArgs(-2);
        this.options.addOption(name);
        Option atts = new Option("a", "atts", false, "attributes to poll");
        atts.setRequired(false);
        atts.setOptionalArg(true);
        atts.setArgs(-2);
        atts.setArgName("attributes");
        this.options.addOption(atts);
        Option period = new Option("p", "period", true, "Polling period");
        period.setRequired(false);
        period.setArgName("period");
        period.setArgs(1);
        this.options.addOption(period);
        Option refresh = new Option("r", "refresh", true, "Period for rebuilding the mbean list");
        refresh.setRequired(false);
        refresh.setArgName("refreshPeriod");
        refresh.setArgs(1);
        this.options.addOption(refresh);
        Option graph = new Option("graph", "graph", true, "Enable graphical output");
        graph.setRequired(false);
        graph.setArgName("graphDefinition");
        graph.setArgs(1);
        this.options.addOption(graph);
        Option console = new Option("console", "console", false, "Send output to stdout");
        console.setRequired(false);
        this.options.addOption(console);
        Option file = new Option("f", "file", true, "Send output to file");
        file.setRequired(false);
        file.setArgName("path");
        file.setArgs(1);
        this.options.addOption(file);
        Option jasmine = new Option("jasmine", "jasmine", true, "Output logged data to jasmine (will disable stdout)");
        jasmine.setRequired(false);
        jasmine.setArgName("jasmineURI");
        jasmine.setArgs(1);
        this.options.addOption(jasmine);
        Option separator = new Option("s", "separator", true, "Set the column separator");
        separator.setRequired(false);
        separator.setArgName("separator");
        separator.setArgs(1);
        this.options.addOption(separator);
        Option cmdid = new Option("cmdid", "cmdid", true, "Cmd Identifier");
        cmdid.setRequired(false);
        cmdid.setArgName("cmdid");
        cmdid.setArgs(1);
        this.options.addOption(cmdid);
        Option target = new Option("target", "target", true, "instances to poll");
        target.setRequired(false);
        target.setOptionalArg(true);
        target.setArgs(-2);
        target.setArgName("instances");
        this.options.addOption(target);
        Option rate = new Option("rate", "rate", false, "attributes rate to poll");
        rate.setRequired(false);
        rate.setOptionalArg(true);
        rate.setArgs(-2);
        rate.setArgName("rate");
        this.options.addOption(rate);
        Option delta = new Option("delta", "delta", false, "attributes delta to poll");
        delta.setRequired(false);
        delta.setOptionalArg(true);
        delta.setArgs(-2);
        delta.setArgName("delta");
        this.options.addOption(delta);
        Option slope = new Option("slope", "slope", false, "attributes slope to poll");
        slope.setRequired(false);
        slope.setOptionalArg(true);
        slope.setArgs(-2);
        slope.setArgName("slope");
        this.options.addOption(slope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws Exception {
        String defaultTarget;
        String[] targetOption = this.commandLine.getOptionValues("target");
        this.logger.debug("Process -target option", new Object[0]);
        String[] targets = JmxHelper.getJmxTargets(targetOption);
        if (targets == null && (defaultTarget = JmxHelper.getDefaultTarget()) != null) {
            targets = new String[]{defaultTarget};
        }
        if (targets.length > 0) {
            this.contexts = new StatContext[targets.length];
            boolean targetReached = true;
            for (int i = 0; i < this.contexts.length; ++i) {
                this.contexts[i] = new StatContext(this.oldValues);
                String targetName = targets[i];
                this.contexts[i].setName(targetName);
                String jmxUrl = JmxHelper.getJmxUrl(targetName);
                this.contexts[i].setJmxUrl(jmxUrl);
                this.contexts[i].setJmxap(new JmxAp(jmxUrl, this.cmdDispatcher));
                this.contexts[i].setDomain("unknown_domain");
                this.contexts[i].setServer("unknown_server_name");
                try {
                    ObjectName j2eeServer = ObjectName.getInstance("*:j2eeType=J2EEServer,*");
                    ObjectName j2eeDomain = ObjectName.getInstance("*:j2eeType=J2EEDomain,*");
                    MBeanServerConnection mbscnx = this.contexts[i].getJmxap().getMBeanServerConnection();
                    Iterator onames = mbscnx.queryNames(j2eeServer, null).iterator();
                    boolean isJ2eeServer = false;
                    if (onames.hasNext()) {
                        ObjectName on = (ObjectName)onames.next();
                        this.contexts[i].setServer(on.getKeyProperty("name"));
                        this.contexts[i].setDomain(on.getDomain());
                        isJ2eeServer = true;
                    }
                    if (!isJ2eeServer) {
                        for (ObjectName on : mbscnx.queryNames(j2eeDomain, null)) {
                            this.contexts[i].setDomain(on.getDomain());
                        }
                    }
                    if (jmxUrl.equals(targetName)) {
                        this.contexts[i].setAdminNaming(false);
                    }
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        this.logger.warn("Cannot reach target:" + e, new Object[0]);
                        targetReached = false;
                    }
                }
                finally {
                    this.contexts[i].getJmxap().releaseMBeanServerConnection();
                }
                if (this.aOption) {
                    if (this.aliases()) {
                        for (String mbeanNamePattern : this.multiAttsSimple.keySet()) {
                            List<String> attNames = this.multiAttsSimple.get(mbeanNamePattern);
                            if (!attNames.contains("*")) continue;
                            String[] foundAtts = this.getAttsToPoll(this.contexts[i], ObjectName.getInstance(mbeanNamePattern));
                            ArrayList<String> newAttNames = new ArrayList<String>();
                            newAttNames.add(attNames.get(0));
                            for (int j = 0; j < foundAtts.length; ++j) {
                                newAttNames.add(foundAtts[j]);
                            }
                            this.multiAttsSimple.put(mbeanNamePattern, newAttNames);
                            attNames = null;
                        }
                    } else if (this.aOption && (this.attsSimple == null || this.attsSimple.length == 0)) {
                        this.attsSimple = this.getAttsToPoll(this.contexts[i], this.objectName);
                    }
                }
                this.logger.info("Target {0} - {1}", this.contexts[i].getName(), this.contexts[i].getJmxUrl());
            }
            if (targetReached) {
                this.cmdDispatcher.setRunning();
            }
        } else {
            this.logger.error("Could not found targets. Use probe-config.xml file to define targets, or define jasmine.jmx.url for default target url definition.", new Object[0]);
            throw new Exception("No target defined");
        }
        this.mbeanPoll();
    }

    private static double floor(double a, int n) {
        double p = Math.pow(10.0, n);
        return Math.floor(a * p + 0.5) / p;
    }

    private static String[] toArray(List<String> arrayList) {
        int size = arrayList.size();
        String[] array = new String[size];
        for (int i = 0; i < size; ++i) {
            array[i] = arrayList.get(i);
        }
        return array;
    }

    private boolean aliases() {
        return !this.aliases.isEmpty();
    }
}

