/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Dump.java 38 2007-12-12 13:03:04Z tokmensa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

import org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxAP;

/**
 * Command that dumps thread information on a given J2EE server.
 */
public class Dump extends AbstractCommand {
    /**
     * Implementation of inherited abstract method.
     *
     * Executes the command.
     *
     * @see AbstractCommand#exec()
     *
     * @return 0 if succeeded, an error code otherwise.
     */
    @Override
    public int exec(final CommandDispatcher cmdDispatcher) {
        JmxAP jap = null;
        try {
            MBeanServerConnection cnx = jap.getMBeanServerConnection();
            ObjectName on = new ObjectName("java.lang:type=Threading");
            System.out.println(cnx.getAttribute(on, "ThreadStackDump"));
            return 0;
        } catch (InstanceNotFoundException e) {
            System.err.println("Not available. Missing required mbean (java.lang:type=Threading)");
            System.err.println("Run JOnAS on JDK 1.5 and enable management.");
            return 1;
        } catch (Exception e) {
            e.printStackTrace();
            return 2;
        } finally {
            jap.releaseMBeanServerConnection();
        }
    }

    /**
     * Abstract redefinition of inherited method.
     *
     * Retrieves the command's summary.
     *
     * @see AbstractCommand#summary()
     *
     * @return Command's summary.
     */
    @Override
    public String summary() {
        return "Dumps the threads into stdout";
    }
}
