/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Graph.java 39 2007-12-12 14:51:20Z tokmensa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.graph;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.ow2.jasmine.monitoring.mbeancmd.graph.conf.GraphConfig;

/**
 * Implements a graph.
 */
public class Graph implements SerieListener {
    /**
     * Constructor: creates the graph based on the configuration
     * and starts logging if enabled.
     *
     * @param conf  Graph configuration.
     */
    public Graph(final GraphConfig conf) {
        this.conf = conf;
        display = new GraphDisplay(conf);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("New graph: " + conf.getId());
        }
    }

    /**
     * Implementation of inherited method.
     *
     * @see SerieListener#update(String, long, long)
     */
    public void update(final String serie, final long x, final long y) {
        display.update(serie, x, (double) y);
    }

    /**
     * Implementation of inherited method.
     *
     * @see SerieListener#update(String, long, double)
     */
    public void update(final String serie, final long t, final double y) {
        display.update(serie, t, y);
    }

    /**
     * Implementation of inherited method.
     *
     * @see SerieListener#update(String, double, long)
     */
    public void update(final String serie, final double x, final long y) {
        display.update(serie, (new Double(x)).longValue(), (double) y);
    }

    /**
     * Implementation of inherited method.
     *
     * @see SerieListener#update(String, double, double)
     */
    public void update(final String serie, final double x, final double y) {
        display.update(serie, (new Double(x)).longValue(), y);
    }

    /**
     * @return  Graph configuration.
     */
    public GraphConfig getConfig() {
        return conf;
    }

    /**
     * Graph configuration.
     */
    private GraphConfig conf = null;

    /**
     * Graph display.
     */
    private GraphDisplay display = null;

    /**
     * Event logger.
     */
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
}
