/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SerieListener.java 39 2007-12-12 14:51:20Z tokmensa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.graph;

/**
 * Interface for any class that will receive series data.
 */
public interface SerieListener {
    /**
     * Updates the series data by adding a point.
     *
     * @param serie  Name of the series.
     * @param x      Abscissa of the new point.
     * @param y      Ordinate of the new point.
     */
    void update(final String serie, final long x, final long y);

    /**
     * Updates the series data by adding a point.
     *
     * @param serie  Name of the series.
     * @param x      Abscissa of the new point.
     * @param y      Ordinate of the new point.
     */
    void update(final String serie, final long x, final double y);

    /**
     * Updates the series data by adding a point.
     *
     * @param serie  Name of the series.
     * @param x      Abscissa of the new point.
     * @param y      Ordinate of the new point.
     */
    void update(final String serie, final double x, final long y);

    /**
     * Updates the series data by adding a point.
     *
     * @param serie  Name of the series.
     * @param x      Abscissa of the new point.
     * @param y      Ordinate of the new point.
     */
    void update(final String serie, final double x, final double y);
}
