/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: GraphConfig.java 39 2007-12-12 14:51:20Z tokmensa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.graph.conf;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/**
 * Graph configuration.
 */
public class GraphConfig extends Constants {
    /**
     * Creates a graph configuration based on a Configuration parent.
     *
     * @param parent  Configuration parent.
     */
    public GraphConfig(final Configuration parent) {
        this.parent = parent;
    }

    /**
     * @return  Configuration parent.
     */
    public Configuration getParent() {
        return parent;
    }

    /**
     * Gets the legend for a given id.
     *
     * @param id  Identifier to search for.
     *
     * @return  Legend corresponding to id.
     */
    public String getLegend(final String id) {
        return (String) series.get(id);
    }

    /**
     * Adds a series.
     *
     * @param id      Identifier of the series.
     * @param legend  Legend name.
     */
    public void addSerie(final String id, final String legend) {
        series.put(id, legend);
    }

    /**
     * @return  Identifiers of all series.
     */
    public String[] getSerieIds() {
        String[] ids = new String[1];
        Set s = series.keySet();
        return (String[]) s.toArray(ids);

    }

    /**
     * @return  Graph title.
     */
    public String getTitle() {
        return title;
    }

    /**
     * @param title  New graph title.
     */
    public void setTitle(final String title) {
        this.title = title;
    }

    /**
     * @return  Graph identifier.
     */
    public String getId() {
        return id;
    }

    /**
     * @param id  Graph identifier to set.
     */
    public void setId(final String id) {
        this.id = id;
    }

    /**
     * Graph identifier.
     */
    private String id = null;

    /**
     * Graph title.
     */
    private String title = null;

    /**
     * Map of series.
     */
    private Map series = new TreeMap();

    /**
     * Parent configuration.
     */
    private Configuration parent = null;
}
