/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: EntityData.java 55 2007-12-17 16:03:02Z tokmensa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;


/**
 * Data retrieved from entity beans.
 */
public class EntityData extends SampleData {
    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#compute(SampleData)
     */
    public void compute(final SampleData needs_cast) {
        EntityData prev = (EntityData) needs_cast;
        // nothing to do
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#getInnerPrintHeader()
     */
    protected String getInnerPrintHeader() {
        return header.replaceAll(";", getSeparator());
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#getInnerPrintData()
     */
    protected String getInnerPrintData() {
        Integer[] counters = (Integer[]) this.getAttribute("entityCounters");
        return  this.getAttributeAsInt("cacheSize") + getSeparator()    // Total nb of instances in memory
              + this.getAttributeAsInt("poolSize") + getSeparator()     // Current nb of free instances
              + this.getAttributeAsInt("minPoolSize") + getSeparator()
              + this.getAttributeAsInt("maxCacheSize") + getSeparator()
              + counters[0] + getSeparator()    // Current nb of instances used inside transactions
              + counters[1] + getSeparator()    // Current nb of instances used outside transactions
              + counters[2] + getSeparator()    // Current nb of unused, ready instances
              + counters[3] + getSeparator()    // Current nb of instances marked removed
              + counters[4] + getSeparator()    // Total nb of PK in memory
              + counters[5];                    // Current nb of passivated instances
    }

    /**
     * Default output header.
     */
    private static final String header = "cacheSize;poolSize;minPoolSize;maxCacheSize;"
                                       + "usedInTx;usedOutTx;unusedReady;markedRemoved;pkNumber;passivated";
}
