/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.io.IOException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.ow2.jasmine.monitoring.mbeancmd.context.JmxContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SLBData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.XSampleData;

public class SLBSampler
extends Sampler {
    private static final String[] attIds = new String[]{"name", "cacheSize", "poolSize", "minPoolSize", "maxCacheSize", "sessionTimeOut"};

    public SLBSampler(JmxContext context) {
        super(context);
    }

    public String getDefaultOn() {
        return "*:j2eeType=StatelessSessionBean,*";
    }

    protected SampleData newSampleData() {
        return new XSampleData();
    }

    protected SampleData poll(SampleData data) {
        this.pollSLBs((XSampleData)data);
        data.setValid(true);
        return data;
    }

    private void pollSLBs(XSampleData data) {
        ObjectName[] oNames = this.context.getOnames().toArray(new ObjectName[this.context.getOnames().size()]);
        for (int i = 0; i < oNames.length; ++i) {
            SLBData slbdata = new SLBData();
            slbdata.setObjectName(oNames[i]);
            slbdata.setSampleTime(System.currentTimeMillis());
            this.pollSLB(oNames[i], slbdata);
            if (!slbdata.isValid()) continue;
            data.put(oNames[i], slbdata);
        }
    }

    private void pollSLB(ObjectName on, SLBData data) {
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        try {
            cnx = this.getMBeanServerConnection();
            al = cnx.getAttributes(on, attIds);
            this.releaseMbeanServerConnection();
            cnx = null;
            for (Attribute att : al) {
                data.setAttribute(att);
            }
            data.setServerInfo(this.getName(), this.getServer(), this.getDomain());
            data.setValid(true);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace(System.err);
        }
        catch (ReflectionException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }
}

