package org.ow2.jasmine.monitoring.mbeancmd.jasmine;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.mule.extras.client.MuleClient;
import org.mule.umo.UMOException;

public class MuleDispatcher implements Runnable {

    private String version = "v1";

    /**
     *
     */
    private BufferedReader reader;

    /**
     *
     */
    private String jasmineURI;

    public MuleDispatcher(BufferedReader reader, String jasmineURI) {
        this.reader = reader;
        this.jasmineURI = jasmineURI;
    }

    public void run() {

        try {
            MuleClient client = null;
            while (client == null) {
                Thread.sleep(1000);
                client = new MuleClient();
            }
            String header = "mbeancmd_values_" + version + "\n" + reader.readLine() + "\n";
            while (true) {

                String msg = header + reader.readLine();
                try {
                    client.dispatch(jasmineURI, msg, null);
                } catch (NullPointerException e) {

                    Logger.getLogger(MuleDispatcher.class.getName()).log(Level.INFO,
                        "Mule stopped ... Message is not delivered anymore to " + jasmineURI);
                    break;
                }
            }
        } catch (UMOException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

    }

}
