/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.Iterator;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

import org.ow2.jasmine.monitoring.mbeancmd.context.JmxContext;
import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;

/**
 * Data sampler for the Sun Java VM.
 */
public class CpuSunSampler extends Sampler {
    /**
     * Implementation of inherited method.
     *
     * @see Sampler#Sampler(String)
     */
    public CpuSunSampler(final JmxContext context) {
        super(context);
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see Sampler#getDefaultOn()
     */
    public String getDefaultOn() {
        return "java.lang:type=OperatingSystem";
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see Sampler#newSampleData()
     */
    protected SampleData newSampleData() {
        return new CpuSunData();
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see Sampler#poll(SampleData)
     * @see CpuSunSampler#pollCpuSun(CpuSunData)
     */
    protected SampleData poll(final SampleData data) {
        pollCpuSun((CpuSunData) data);
        return data;
    }

    /**
     * Polls Sun Java VM CPU data.
     *
     * @param data  ServerData to add polled information to.
     */
    private void pollCpuSun(final CpuSunData data) {
        long cpuTime = 0;
        long availableProcessors = 0;
        AttributeList al = null;
        MBeanServerConnection cnx = getMBeanServerConnection();
        String[] attIds = {
                "ProcessCpuTime",
                "AvailableProcessors"
        };

        ObjectName[] oNames = (ObjectName[]) context.getOnames().toArray(new ObjectName[context.getOnames().size()]);

        for (int i = 0; i < oNames.length; i++) {
            try {
                al = cnx.getAttributes(oNames[i], attIds);
                Iterator it = al.iterator();
                Attribute att = (Attribute) it.next();                  // ProcessCpuTime
                cpuTime += Long.parseLong(att.getValue().toString());
                att = (Attribute) it.next();                            // AvailableProcessors
                availableProcessors += Long.parseLong(att.getValue().toString());
                data.setValid(true);
            } catch (Exception e) {
                e.printStackTrace(System.err);
                e.getCause().printStackTrace(System.err);
            }
        }
        releaseMbeanServerConnection();
        data.setProcessCpuTime(cpuTime);
        data.setAvailableProcessors(availableProcessors);
        data.setServerInfo(getName(), getServer(), getDomain());
        if( oNames.length > 0) {
            data.setObjectName(oNames[0]);
        }

    }
}
