/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JCACFData.java 55 2007-12-17 16:03:02Z tokmensa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import javax.management.Attribute;

/**
 * Data retrieved from JCA Connection Factories.
 */
public class JCACFData extends SampleData {
    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#compute(SampleData)
     */
    public void compute(final SampleData needs_cast) {
        JCACFData prev = (JCACFData) needs_cast;
        if (prev != null) {
            // servedOpenRate
            int deltaServedOpen = this.getAttributeAsInt("servedOpen") - prev.getAttributeAsInt("servedOpen");
            double dt = (this.getSampleTime() - prev.getSampleTime()) / 1000.0;
            this.setAttribute(new Attribute("servedOpenRate", new Double(deltaServedOpen / dt)));

            // meanWaitTime
            int deltaWaiters = this.getAttributeAsInt("waiterCount") - prev.getAttributeAsInt("waiterCount");
            long deltaWaitTime = this.getAttributeAsLong("waitingTime") - prev.getAttributeAsLong("waitingTime");
            double meanWaitTime = (deltaWaiters > 0 ? 1.0 * deltaWaitTime / deltaWaiters : 0.0);
            this.setAttribute(new Attribute("meanWaitTime", new Double(meanWaitTime)));
        } else {
            this.setAttribute(new Attribute("servedOpenRate", new Double(0.0)));
            this.setAttribute(new Attribute("meanWaitTime", new Double(0.0)));
        }
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#getInnerPrintHeader()
     */
    protected String getInnerPrintHeader() {
        return header.replaceAll(";", getSeparator());
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#getInnerPrintData()
     */
    protected String getInnerPrintData() {
        return  decimalFormat.format(this.getAttributeAsDouble("servedOpenRate")) + getSeparator()
              + this.getAttributeAsInt("servedOpen") + getSeparator()
              + this.getAttributeAsInt("maxSize") + getSeparator()
              + this.getAttributeAsInt("currentOpened") + getSeparator()
              + this.getAttributeAsInt("currentBusy") + getSeparator()
              + this.getAttributeAsInt("busyMax") + getSeparator()
              + this.getAttributeAsInt("currentWaiters") + getSeparator()
              + this.getAttributeAsInt("waitersHighRecent") + getSeparator()
              + this.getAttributeAsLong("waitingHighRecent") + getSeparator()
              + decimalFormat.format(this.getAttributeAsDouble("meanWaitTime")) + getSeparator()
              + this.getAttributeAsInt("rejectedOpen") + getSeparator()
              + this.getAttributeAsInt("connectionLeaks");
    }

    /**
     * Default output header.
     */
    private static final String header = "servedRate;servedOpen;maxSize;currentOpen;currentBusy;busyMax;currentWaiters;"
                                       + "waitersHighRecent;waitingHighRecent;meanWaitTime;rejectedOpen;connectionLeaks";
}
