/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JoramQData.java 710 2008-01-25 13:36:25Z waeselynck $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import javax.management.Attribute;

/**
 * Data retrieved from JCA Connection Factories.
 */
public class JoramQData extends SampleData {
    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#compute(SampleData)
     */
    public void compute(final SampleData needs_cast) {
        JoramQData prev = (JoramQData) needs_cast;
        if (prev != null) {
            // receive Rate : number of inqueud msg per second 
            long deltaReceived = this.getAttributeAsLong("nbMsgsReceiveSinceCreation") - prev.getAttributeAsLong("nbMsgsReceiveSinceCreation");
            double dt = (this.getSampleTime() - prev.getSampleTime()) / 1000.0;
            this.setAttribute(new Attribute("receiveRate", new Double(deltaReceived / dt)));

            // delivery Rate : number of msg deliveries per second
            long deltaDelivery = this.getAttributeAsLong("nbMsgsDeliverSinceCreation") - prev.getAttributeAsLong("nbMsgsDeliverSinceCreation");
            this.setAttribute(new Attribute("deliveryRate", new Double(deltaDelivery / dt)));
        } else {
            this.setAttribute(new Attribute("receiveRate", new Double(0.0)));
            this.setAttribute(new Attribute("deliveryRate", new Double(0.0)));
        }
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#getInnerPrintHeader()
     */
    protected String getInnerPrintHeader() {
        return header.replaceAll(";", getSeparator());
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#getInnerPrintData()
     */
    protected String getInnerPrintData() {
        
        return  this.getAttribute("AdminName") + getSeparator()
                + this.getAttribute("Type") + getSeparator()
                + this.getAttributeAsInt("PendingMessages") + getSeparator()
                + this.getAttributeAsInt("NbMaxMsg") + getSeparator()
                + decimalFormat.format(this.getAttributeAsDouble("receiveRate")) + getSeparator()
                + decimalFormat.format(this.getAttributeAsDouble("deliveryRate")) + getSeparator()
                + this.getAttributeAsInt("PendingRequests") + getSeparator()
                + this.getAttributeAsInt("Threshold") + getSeparator()
                + this.getAttributeAsLong("creationDate") + getSeparator()
                + this.getAttributeAsLong("nbMsgsReceiveSinceCreation") + getSeparator()
                + this.getAttributeAsLong("nbMsgsDeliverSinceCreation") + getSeparator()
                + this.getAttributeAsLong("nbMsgsSendToDMQSinceCreation") + getSeparator()
        ;
    }

    /**
     * Default output header.
     */
    private static final String header =
        "AdminName;Type;PendingMessages;NbMaxMsg;receiveRate;deliveryRate;PendingRequests;Threshold;"
        + "creationDate;nbMsgsReceiveSinceCreation;nbMsgsDeliverSinceCreation;nbMsgsSendToDMQSinceCreation" ;
}
