/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WebData.java 55 2007-12-17 16:03:02Z tokmensa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;


/**
 * Data retrieved from the HTTP server.
 */
public class WebData extends SampleData {
    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#compute(SampleData)
     */
    public void compute(final SampleData needs_cast) {
        WebData prev = (WebData) needs_cast;
        if (prev != null) {
            long deltaReq = this.httpRequestCount - prev.httpRequestCount;
            httpRequestRate = 1000.0 * deltaReq / (this.getSampleTime() - prev.getSampleTime());

            if (deltaReq > 0) {
                this.procTimePerRequest = 1.0 * (this.procTimeCount - prev.procTimeCount) / deltaReq;
            } else {
                procTimePerRequest = 0.0;
            }
        } else {
            httpRequestRate = 0.0;
            procTimePerRequest = 0.0;
        }
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#getInnerPrintHeader()
     */
    protected String getInnerPrintHeader() {
        return header.replaceAll(";", getSeparator());
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#getInnerPrintData()
     */
    protected String getInnerPrintData() {
        return  getSessionGauge() + getSeparator()
              + decimalFormat.format(getHttpRequestRate()) + getSeparator()
              + getHttpRequestCount() + getSeparator()
              + getPendingHttpRequests() + getSeparator()
              + getHttpErrors() + getSeparator()
              + getSessionCount() + getSeparator()
              + decimalFormat.format(getProcTimePerRequest()) + getSeparator()
              + getMaxProcTime();
    }

    /**
     * @param nb  Session gauge.
     */
    public void setSessionGauge(final long nb) {
        this.sessionGauge = nb;
    }

    /**
     * @return  Session gauge.
     */
    public long getSessionGauge() {
        return this.sessionGauge;
    }

    /**
     * @param nb  Session count.
     */
    public void setSessionCount(final long nb) {
        this.sessionCount = nb;
    }

    /**
     * @return  Session count.
     */
    public long getSessionCount() {
        return this.sessionCount;
    }

    /**
     * @param cnt  HTTP requests count.
     */
    public void setHttpRequestCount(final long cnt) {
        httpRequestCount = cnt;
    }

    /**
     * @return  HTTP requests count.
     */
    public long getHttpRequestCount() {
        return httpRequestCount;
    }

    /**
     * @param cnt  Processing time count.
     */
    public void setProcTimeCount(final long cnt) {
        procTimeCount = cnt;
    }

    /**
     * @return  Processing time count.
     */
    public long getProcTimeCount() {
        return procTimeCount;
    }

    /**
     * @param time  Maximal processing time.
     */
    public void setMaxProcTime(final long time) {
        maxProcTime = time;
    }

    /**
     * @return  Maximal processing time.
     */
    public long getMaxProcTime() {
        return maxProcTime;
    }

    /**
     * @param gauge  Pending HTTP requests.
     */
    public void setPendingHttpRequests(final long gauge) {
        pendingHttpRequests = gauge;
    }

    /**
     * @return  Pending HTTP requests.
     */
    public long getPendingHttpRequests() {
        return pendingHttpRequests;
    }

    /**
     * @param cnt  HTTP errors.
     */
    public void setHttpErrorsCount(final long cnt) {
        httpErrorCount = cnt;
    }

    /**
     * @return  HTTP errors.
     */
    public long getHttpErrors() {
        return httpErrorCount;
    }

    /**
     * @return  HTTP request rate (computed).
     */
    public double getHttpRequestRate() {
        return httpRequestRate;
    }

    /**
     * @return  Processing time per request (computed).
     */
    public double getProcTimePerRequest() {
        return procTimePerRequest;
    }

    /**
     * Session gauge.
     */
    private long sessionGauge = 0;

    /**
     * Session count.
     */
    private long sessionCount = 0;

    /**
     * HTTP requests count.
     */
    private long httpRequestCount = 0;

    /**
     * Processing time count.
     */
    private long procTimeCount = 0;

    /**
     * Maximal processing time.
     */
    private long maxProcTime = 0;

    /**
     * Pending HTTP requests.
     */
    private long pendingHttpRequests = 0;

    /**
     * HTTP errors.
     */
    private long httpErrorCount = 0;

    /**
     * HTTP request rate (computed).
     */
    private double httpRequestRate = 0.0;

    /**
     * Processing time per request (computed).
     */
    private double procTimePerRequest = 0.0;

    private static final String header = "sessions;rate;requests;pending;errors;sessionCount;meanTime;maxTime";

}
