/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.context.JmxContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;

public abstract class Sampler {
    private String objectName = null;
    protected JmxContext context;

    public Sampler(JmxContext context) {
        this.context = context;
    }

    protected final MBeanServerConnection getMBeanServerConnection() {
        return this.context.getJmxap().getMBeanServerConnection();
    }

    protected void releaseMbeanServerConnection() {
        this.context.getJmxap().releaseMBeanServerConnection();
    }

    protected final ObjectName[] queryON(String onProto) {
        ObjectName[] ons = null;
        try {
            MBeanServerConnection cnx = this.getMBeanServerConnection();
            this.context.setOnames(cnx.queryNames(new ObjectName(onProto), null));
            if (!this.context.getOnames().isEmpty()) {
                ons = this.context.getOnames().toArray(new ObjectName[this.context.getOnames().size()]);
                for (int i = 0; i < ons.length; ++i) {
                    System.out.println("Found ObjectName in server " + this.context.getName() + " (" + this.context.getServer() + " on domain " + this.context.getDomain() + "): " + ons[i]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return ons;
    }

    protected abstract String getDefaultOn();

    protected String getOn() {
        return this.objectName;
    }

    public void setOn(String onProto) {
        this.objectName = onProto;
    }

    public void init() {
        if (this.getOn() == null) {
            this.setOn(this.getDefaultOn());
        }
        this.queryON(this.getOn());
    }

    public final SampleData sample(SampleData previous) {
        SampleData data = this.newSampleData();
        try {
            data.setSampleTime(System.currentTimeMillis());
            this.poll(data);
            if (data.isValid()) {
                data.compute(previous);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        if (data.isValid()) {
            return data;
        }
        return null;
    }

    public String getName() {
        return this.context.getName();
    }

    public String getServer() {
        return this.context.getServer();
    }

    public String getDomain() {
        return this.context.getDomain();
    }

    protected abstract SampleData newSampleData();

    protected abstract SampleData poll(SampleData var1);
}

