/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.context.JmxContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.WebData;

public class WebSampler
extends Sampler {
    private ObjectName[] onGRP = null;
    private ObjectName[] onSessions = null;
    private ObjectName[] onThreadPool = null;

    public WebSampler(JmxContext context) {
        super(context);
    }

    public String getDefaultOn() {
        return null;
    }

    public void init() {
        this.onGRP = this.queryON("*:type=GlobalRequestProcessor,*");
        this.onThreadPool = this.queryON("*:type=ThreadPool,*");
        this.onSessions = this.queryON("*:type=Manager,*");
    }

    protected SampleData newSampleData() {
        return new WebData();
    }

    protected SampleData poll(SampleData data) {
        boolean status = true;
        this.pollSessions((WebData)data);
        status = status && data.isValid();
        this.pollGlobalRequestProcessor((WebData)data);
        status = status && data.isValid();
        this.pollThreadPool((WebData)data);
        status = status && data.isValid();
        data.setServerInfo(this.getName(), this.getServer(), this.getDomain());
        data.setValid(status);
        return data;
    }

    private void pollSessions(WebData data) {
        long nbSess = 0L;
        long sessionCnt = 0L;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"activeSessions", "sessionCounter"};
        for (int i = 0; i < this.onSessions.length; ++i) {
            if (this.onSessions[i] == null) continue;
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onSessions[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                nbSess += (long)((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                sessionCnt += (long)((Integer)att.getValue()).intValue();
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setSessionGauge(nbSess);
        data.setSessionCount(sessionCnt);
    }

    private void pollGlobalRequestProcessor(WebData data) {
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"requestCount", "errorCount", "processingTime", "maxTime"};
        long reqCount = 0L;
        long errCount = 0L;
        long procTime = 0L;
        long maxTime = 0L;
        for (int i = 0; i < this.onGRP.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onGRP[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                reqCount += (long)((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                errCount += (long)((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                procTime += ((Long)att.getValue()).longValue();
                att = (Attribute)it.next();
                long max = (Long)att.getValue();
                maxTime = max > maxTime ? max : maxTime;
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setHttpRequestCount(reqCount);
        data.setHttpErrorsCount(errCount);
        data.setProcTimeCount(procTime);
        data.setMaxProcTime(maxTime);
    }

    private void pollThreadPool(WebData data) {
        long nbBusy = 0L;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"currentThreadsBusy"};
        for (int i = 0; i < this.onThreadPool.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onThreadPool[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                long busy = ((Integer)att.getValue()).intValue();
                nbBusy += busy == 1L ? 0L : busy;
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setPendingHttpRequests(nbBusy);
    }
}

