/**
 * JASMINe
 * Copyright (C) 2007-2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JmxContext.java 2731 2008-11-11 11:02:21Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.context;

import java.io.Serializable;
import java.util.Set;

import javax.management.ObjectName;

import org.ow2.jasmine.monitoring.mbeancmd.JmxAP;

/**
 * Main context for jmx environment.
 * @author Guillaume Renault
 *
 */
public abstract class JmxContext implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = -9159123017384356614L;

    /**
     * Name set for the server in the jmxurls.properties file.
     */
    protected String name = null;

    /**
     * Server name.
     */
    protected String server = null;

    /**
     * Server domain.
     */
    protected String domain;

    /**
     * JMX URL to connect to.
     */
    protected String jmxUrl = null;

    /**
     * JMX Access Point.
     */
    protected JmxAP jmxap = null;

    /**
     * Targeted names.
     */
    protected Set<ObjectName> onames = null;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServer() {
        return server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getJmxUrl() {
        return jmxUrl;
    }

    public void setJmxUrl(String jmxUrl) {
        this.jmxUrl = jmxUrl;
    }

    public JmxAP getJmxap() {
        return jmxap;
    }

    public void setJmxap(JmxAP jmxap) {
        this.jmxap = jmxap;
    }

    public Set<ObjectName> getOnames() {
        return onames;
    }

    public void setOnames(Set<ObjectName> onames) {
        this.onames = onames;
    }


}
