/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Constants.java 1928 2008-07-30 08:45:19Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.graph.conf;

import java.io.InvalidObjectException;
import java.util.Locale;

/**
 * Graph constants.
 */
public class Constants {
    /**
     * The "long" data type.
     */
    public static final int LONG = 1;

    /**
     * The "double" data type.
     */
    public static final int DOUBLE = 2;

    /**
     * The "time" data type.
     */
    public static final int TIME = 3;

    /**
     * Gets the type of a format.
     *
     * @param f  Format, for example "double", "long" or "time".
     *           Case is ignored.
     *
     * @return  {@link Constants#LONG}, {@link Constants#DOUBLE} or
     *          {@link Constants#TIME}
     *
     * @throws InvalidObjectException  f doesn't match any format.
     */
    public static final int getType(final String f) throws InvalidObjectException {
        String toLower = f.toLowerCase(Locale.ENGLISH);
        if(toLower.equals("long")) {
            return LONG;
        } else if(toLower.equals("double")) {
            return DOUBLE;
        } else if(toLower.equals("time")) {
            return TIME;
        } else {
            throw new InvalidObjectException("No match for type: "+toLower);
        }
    }
    /**
     * Configuration file for the graph.
     */
    public static final String GRAPH_CONFIG_PATH="graph.conf.path";
}
