/**
 * JASMINe
 * Copyright (C) 2005-2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SLBData.java 2971 2009-01-12 22:13:53Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.HashMap;
import java.util.Map;


/**
 * Sampler for retrieving data from stateless session beans.
 */
public class SLBData extends SampleData {
    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#compute(SampleData)
     */
    public void compute(final SampleData needs_cast) {
        SLBData prev = (SLBData) needs_cast;
        // nothing to do
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#getInnerPrintHeader()
     */
    protected String getInnerPrintHeader() {
        return header.replaceAll(";", getSeparator());
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#getInnerPrintData()
     */
    protected String getInnerPrintData() {
        return  this.getAttributeAsInt("cacheSize") + getSeparator()
              + this.getAttributeAsInt("poolSize") + getSeparator()
              + this.getAttributeAsInt("minPoolSize") + getSeparator()
              + this.getAttributeAsInt("maxCacheSize") + getSeparator()
              + this.getAttributeAsInt("sessionTimeOut");
    }

    @Override
    public Map<String, ?> getValueOfAttributes() {
        HashMap<String, Object> valueOfAttributes = new HashMap<String, Object>();
        valueOfAttributes.put("cacheSize", getAttributeAsInt("cacheSize"));
        valueOfAttributes.put("poolSize", getAttributeAsInt("poolSize"));
        valueOfAttributes.put("minPoolSize", getAttributeAsInt("minPoolSize"));
        valueOfAttributes.put("maxCacheSize", getAttributeAsInt("maxCacheSize"));
        valueOfAttributes.put("sessionTimeOut", getAttributeAsInt("sessionTimeOut"));
        return valueOfAttributes;
    }

    /**
     * Default output header.
     */
    private final String header = "cacheSize;poolSize;minPoolSize;maxCacheSize;sessionTimeOut";
}
