/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SamplerFactory.java 4225 2009-07-01 15:15:52Z jlegrand $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import org.ow2.jasmine.monitoring.mbeancmd.context.JmxContext;

/**
 * Sampler factory.
 */
public class SamplerFactory {
    /**
     * Dummy constructor to avoid the class from being used
     * in any other way than calling the CommandDispatcher.newSampler method.
     */
    protected SamplerFactory() {
        // Nothing
    }

    /**
     * Creates a sampler of a given type. Calls
     * {@link SamplerFactory#newSampler(String, String)}
     * with urlString set to null.
     *
     * @param type  Sampler type.
     *
     * @return  Created sampler, null if type doesn't match  any sampler.
     */
    public static Sampler newSampler(final String type) {
        return newSampler(type, null);
    }

    /**
     * Creates a sampler of a given type and a given JMX URL.
     *
     * @param type       Sampler type.
     * @param urlString  JMX URL.
     *
     * @return  Created sampler, null if type doesn't match  any sampler.
     */
    public static Sampler newSampler(final String type, final JmxContext context) {
        Sampler sampler = null;

        if ("web".equals(type)) {
            sampler = new WebSampler(context);
        }
        if ("tx".equals(type)) {
            sampler = new TxSampler(context);
        }
        if ("cpusun".equals(type)) {
            System.out.println("creating CPUSunSampler");
            sampler = new CpuSunSampler(context);
        }
        if ("server".equals(type)) {
            sampler = new ServerSampler(context);
        }
        if ("datasource".equals(type)) {
            sampler = new DSSampler(context);
        }
        if ("jcacf".equals(type)) {
            sampler = new JCACFSampler(context);
        }
        if ("servlet".equals(type)) {
            sampler = new ServletSampler(context);
        }
        if ("stateless".equals(type)) {
            sampler = new SLBSampler(context);
        }
        if ("stateful".equals(type)) {
            sampler = new SFBSampler(context);
        }
        if ("entity".equals(type)) {
            sampler = new EntitySampler(context);
        }
        if ("joramQueue".equals(type)) {
            sampler = new JoramQSampler(context);
        }

        return sampler;
    }
}
