/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.graph.conf;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.util.XMLErrorHandler;
import org.ow2.jasmine.monitoring.mbeancmd.graph.conf.Configuration;
import org.ow2.jasmine.monitoring.mbeancmd.graph.conf.Constants;
import org.ow2.jasmine.monitoring.mbeancmd.graph.conf.GraphConfig;
import org.ow2.jasmine.monitoring.mbeancmd.graph.conf.SerieConfig;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Configurator
extends Constants
implements Configuration {
    private Map series = new TreeMap();
    private Map graphs = new TreeMap();
    private Document doc = null;
    private String separator = ";";
    private String abscissColumn = "date";
    private String mbeanColumn = "mbean";
    private SimpleDateFormat simpleDateFormat = null;

    public static void main(String[] args) {
        Configurator cf = new Configurator();
        cf.loadConfig("./src/xml/graph2.xml");
        String[] s = cf.getSerieIds();
        String[] g = cf.getGraphIds();
        GraphConfig gc = cf.getGraphConfig("g1");
        s = gc.getSerieIds();
        System.out.println(g[0]);
        System.out.println(gc.getLegend(s[1]));
        System.out.println(cf.getSerieConfig(s[1]).getTitle());
        System.out.println("Absciss=" + cf.getAbscissColumn());
        System.out.println("separator=" + cf.getSeparator());
        System.out.println("dateFormat=" + cf.getDateFormat().toPattern());
    }

    public SerieConfig getSerieConfig(String id) {
        return (SerieConfig)this.series.get(id);
    }

    public String[] getSerieIds() {
        String[] s = new String[1];
        return this.series.keySet().toArray(s);
    }

    public GraphConfig getGraphConfig(String id) {
        return (GraphConfig)this.graphs.get(id);
    }

    public String[] getGraphIds() {
        String[] s = new String[1];
        return this.graphs.keySet().toArray(s);
    }

    public void loadConfig(String conf) {
        String configuration = conf == null ? System.getProperty("graph.conf.path") : conf;
        SAXReader reader = new SAXReader();
        reader.setValidation(true);
        reader.setStripWhitespaceText(false);
        reader.setEntityResolver((EntityResolver)new MyEntityResolver());
        reader.setErrorHandler((ErrorHandler)new XMLErrorHandler());
        try {
            this.doc = reader.read(configuration);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        this.parseParent();
        this.parseSeries();
        this.parseGraphs();
    }

    public static LineNumberReader getDTD() {
        InputStream dtd = Thread.currentThread().getContextClassLoader().getResourceAsStream("xml/graph.dtd");
        return new LineNumberReader(new InputStreamReader(dtd));
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getAbscissColumn() {
        return this.abscissColumn;
    }

    public SimpleDateFormat getDateFormat() {
        return this.simpleDateFormat;
    }

    private void parseSeries() {
        Iterator it = this.doc.selectNodes("//serie-def").iterator();
        while (it.hasNext()) {
            this.addSerie((Node)it.next());
        }
    }

    private void addSerie(Node node) {
        SerieConfig sc = new SerieConfig(this);
        String id = node.selectSingleNode("@id").getText();
        sc.setId(id);
        sc.setTitle(node.selectSingleNode("./name").getText());
        Node nd = node.selectSingleNode("./description");
        if (nd != null) {
            sc.setDescription(nd.getText());
        }
        if ((nd = node.selectSingleNode("./pattern")) != null) {
            sc.setMbeanPattern(nd.getText());
        }
        try {
            sc.setXAxis(node.selectSingleNode("./x/@col").getText());
            sc.setXType(Constants.getType(node.selectSingleNode("./x/@type").getText()));
        }
        catch (Exception e) {
            sc.setXAxis(this.abscissColumn);
            sc.setXType(3);
        }
        try {
            sc.setYAxis(node.selectSingleNode("./y/@col").getText());
            sc.setYType(Constants.getType(node.selectSingleNode("./y/@type").getText()));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.series.put(id, sc);
    }

    private void parseGraphs() {
        Iterator it = this.doc.selectNodes("//graph").iterator();
        while (it.hasNext()) {
            this.addGraph((Node)it.next());
        }
    }

    private void addGraph(Node node) {
        GraphConfig gc = new GraphConfig(this);
        String id = node.selectSingleNode("@id").getText();
        gc.setId(id);
        gc.setTitle(node.selectSingleNode("./title").getText());
        for (Node nd : node.selectNodes("./serie")) {
            String sid = nd.selectSingleNode("@ref").getText();
            String legend = this.parseSerieLegend(nd);
            gc.addSerie(sid, legend);
        }
        this.graphs.put(id, gc);
    }

    private String parseSerieLegend(Node serie) {
        String serieId = serie.selectSingleNode("@ref").getText();
        String val = "";
        if (!serie.hasContent()) {
            val = this.doc.selectSingleNode("//serie-def[@id='" + serieId + "']/name").getText();
        } else {
            Element element = (Element)serie;
            int size = element.nodeCount();
            for (int i = 0; i < size; ++i) {
                Node n = element.node(i);
                String type = n.getName();
                val = "i".equals(type) ? val + this.evalINode(n, serieId) : val + n.getText();
            }
        }
        val = val.replaceAll("[\\t\\n\\f\\r]", " ");
        val = val.trim();
        val = val.replaceAll("[ ]{2,}", " ");
        return val;
    }

    private String evalINode(Node inode, String serieId) {
        Node n;
        String value = "";
        boolean evaluated = false;
        Node node = inode.selectSingleNode("./@text");
        if (node != null) {
            String elementName = node.getStringValue();
            Node n2 = this.doc.selectSingleNode("//serie-def[@id='" + serieId + "']/" + elementName);
            if (n2 != null) {
                value = n2.getText();
                evaluated = true;
            }
        }
        node = inode.selectSingleNode("./@ref");
        if (!evaluated && node != null && (n = this.doc.selectSingleNode("//*[@id='" + node.getStringValue() + "']")) != null) {
            value = n.getText();
            evaluated = true;
        }
        node = inode.selectSingleNode("./@link");
        if (!evaluated && node != null) {
            n = this.doc.selectSingleNode(node.getStringValue());
            if (node != null) {
                value = n.getText();
                evaluated = true;
            }
        }
        return value;
    }

    private void parseParent() {
        String df;
        Element node = this.doc.getRootElement();
        Node nd = node.selectSingleNode("./@separator");
        if (nd != null) {
            this.separator = nd.getText();
        }
        if ((nd = node.selectSingleNode("./@absciss")) != null) {
            this.abscissColumn = nd.getText();
        }
        if ((nd = node.selectSingleNode("./mbean")) != null) {
            this.mbeanColumn = nd.getText();
        }
        this.simpleDateFormat = (nd = node.selectSingleNode("./@timeformat")) != null ? ((df = nd.getText()).toLowerCase(Locale.ENGLISH).equals("long") ? null : new SimpleDateFormat(nd.getText())) : new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    }

    private class MyEntityResolver
    implements EntityResolver {
        private MyEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputSource source = null;
            if (publicId.equals("-//OW2//DTD JASMINe MBeanCmd 1.0//EN")) {
                URL dtd = Thread.currentThread().getContextClassLoader().getResource("xml/graph.dtd");
                source = new InputSource(dtd.toString());
            }
            return source;
        }
    }
}

