/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.HashMap;
import java.util.Map;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CpuSunData
extends SampleData {
    private long processCpuTime = 0L;
    private long availableProcessors = 0L;
    private long currentCpuTime = 0L;
    private double currentCpuLoad = 0.0;
    private static final String header = "processCpuTime;currentCpuTime;currentCpuLoad";

    @Override
    public void compute(SampleData needs_cast) {
        CpuSunData prev = (CpuSunData)needs_cast;
        if (prev != null) {
            this.processCpuTime /= 1000000L;
            this.currentCpuTime = this.processCpuTime - prev.processCpuTime;
            long deltaTime = this.getSampleTime() - prev.getSampleTime();
            this.currentCpuLoad = (double)this.currentCpuTime * 100.0 / (double)(deltaTime * this.availableProcessors);
        } else {
            this.processCpuTime /= 1000000L;
            this.currentCpuTime = 0L;
            this.currentCpuLoad = 0.0;
        }
    }

    @Override
    protected String getInnerPrintHeader() {
        return header.replaceAll(";", CpuSunData.getSeparator());
    }

    @Override
    protected String getInnerPrintData() {
        return decimalFormat.format(this.getProcessCpuTime()) + CpuSunData.getSeparator() + decimalFormat.format(this.getCurrentCpuTime()) + CpuSunData.getSeparator() + decimalFormat.format(this.getCurrentCpuLoad());
    }

    public double getProcessCpuTime() {
        return this.processCpuTime;
    }

    public void setProcessCpuTime(long processCpuTime) {
        this.processCpuTime = processCpuTime;
    }

    public double getAvailableProcessors() {
        return this.availableProcessors;
    }

    public void setAvailableProcessors(long availableProcessors) {
        this.availableProcessors = availableProcessors;
    }

    public double getCurrentCpuTime() {
        return this.currentCpuTime;
    }

    public void setCurrentCpuTime(long currentCpuTime) {
        this.currentCpuTime = currentCpuTime;
    }

    public double getCurrentCpuLoad() {
        return this.currentCpuLoad;
    }

    public void setCurrentCpuLoad(long currentCpuLoad) {
        this.currentCpuLoad = currentCpuLoad;
    }

    @Override
    public Map<String, ?> getValueOfAttributes() {
        HashMap<String, Number> valueOfAttributes = new HashMap<String, Number>();
        valueOfAttributes.put("processCpuTime", this.processCpuTime);
        valueOfAttributes.put("currentCpuTime", this.currentCpuTime);
        valueOfAttributes.put("currentCpuLoad", this.currentCpuLoad);
        return valueOfAttributes;
    }
}

