/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 */
package org.ow2.jasmine.monitoring.mbeancmd.audit.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

import javax.management.Attribute;

import org.ow2.jasmine.monitoring.mbeancmd.audit.Metric;

/**
 * @author waeselyf
 * 
 */
public class MetricMath {

    /**
     * Computes the sum of the attr attribute for all metrics in l. 
     * @param attr
     * @param l
     * @return a double value as the sum
     */
    public static double sum(String attr, LinkedList<Metric> l) {
        double ret = 0.0;
        boolean isValid = false;

        if (!l.isEmpty()) {
            Attribute att = l.peek().getAttribute(attr);
            isValid = (att != null) && MetricMath.isNum(att.getValue());
        }
        if (isValid) {
            Iterator<Metric> it = l.iterator();
            while (it.hasNext()) {
                ret += toDouble(it.next().getAttribute(attr));
            }
        }
        return ret;
    }

    /**
     * Returns the value of attr as a double. 
     * @param attr
     * @return If the attribute value is numeric, returns a double representing this value, else returns zero.
     */
    public static double toDouble(Attribute attr) {
        double ret = 0.0;
        if ((attr != null) && MetricMath.isNum(attr.getValue())) {
            ret = toDouble(attr.getValue());
        }
        return ret;
    }

    /**
     * If o is numeric, returns a double representing thhat number. If not, returns zero.
     * @param o
     * @return a double
     */
    public static double toDouble(Object o) {
        double ret = 0.0;
        Class cl = o.getClass();
        if (cl.equals(Integer.class)) {
            ret = ((Integer) o).doubleValue();
        } else if (cl.equals(Long.class)) {
            ret = ((Long) o).doubleValue();
        } else if (cl.equals(Short.class)) {
            ret = ((Short) o).doubleValue();
        } else if (cl.equals(Byte.class)) {
            ret = ((Byte) o).doubleValue();
        } else if (cl.equals(Short.class)) {
            ret = ((Short) o).doubleValue();
        } else if (cl.equals(Float.class)) {
            ret = ((Float) o).doubleValue();
        } else if (cl.equals(Double.class)) {
            ret = ((Double) o).doubleValue();
        }
        return ret;
    }

    /**
     * Returns the range of a double.
     * 
     * @param d
     * @return a double according to the following:
     * - If |d| <= 10**(MIN_RANGE) returns MIN_RANGE
     * - otherwise returns log10(d). 
     */
    public static double range(double d) {
        d = Math.abs(d);
        d = ( d == 0 ? MIN_RANGE : Math.log10(d) );
        double ret = Math.max(d, MIN_RANGE);
        return ret;
    }

    /**
     * Check whether obj is numeric
     * @param obj
     * @return true or false
     */
    public static boolean isNum(Object obj) {
        return (obj == null) || obj.getClass().isPrimitive() || numerics.containsKey(obj.getClass());
    }


    /**
     * test whether attribute value is zero or not
     * @param att
     * @return
     */
    public static boolean isNonZero(Attribute att) {
        boolean ret = true;
        Object value = att.getValue();
        Class cl = att.getValue().getClass();
        if (cl.equals(Integer.class) || cl.equals(Integer.TYPE)) {
            if (Integer.valueOf(0).equals(value)) {
                ret = false;
            }
        } else if (cl.equals(Long.class) || cl.equals(Long.TYPE)) {
            if (Long.valueOf(0).equals(value)) {
                ret = false;
            }
        } else if (cl.equals(Short.class) || cl.equals(Short.TYPE)) {
            if (Short.valueOf((short) 0).equals(value)) {
                ret = false;
            }
        } else if (cl.equals(Float.class) || cl.equals(Float.TYPE)) {
            if (Float.valueOf(0).equals(value)) {
                ret = false;
            }
        } else if (cl.equals(Double.class) || cl.equals(Double.TYPE)) {
            if (Double.valueOf(0).equals(value)) {
                ret = false;
            }
        } else if (cl.equals(Character.class) || cl.equals(Character.TYPE)) {
            if (Character.valueOf((char) 0).equals(value)) {
                ret = false;
            }
        } else if (cl.equals(Byte.class) || cl.equals(Byte.TYPE)) {
            if (Byte.valueOf((byte) 0).equals(value)) {
                ret = false;
            }
        }

        return ret;
    }

    /**
     * Minimal range value
     */
    public static final double MIN_RANGE = -100.0;
    
    /**
     * Non primitive classes considered as numerics
     */
    private static final HashMap<Class, Class> numerics = new HashMap<Class, Class>();
    static {
        numerics.put(Byte.class, Byte.class);
        numerics.put(Short.class, Short.class);
        numerics.put(Integer.class, Integer.class);
        numerics.put(Long.class, Long.class);
        numerics.put(Float.class, Float.class);
        numerics.put(Double.class, Double.class);
    }
}
