/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.io.IOException;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxAp;
import org.ow2.jasmine.monitoring.mbeancmd.JmxHelper;
import org.ow2.jasmine.monitoring.mbeancmd.Outer;
import org.ow2.jasmine.monitoring.mbeancmd.audit.AuditContext;
import org.ow2.jasmine.monitoring.mbeancmd.audit.Collector;
import org.ow2.jasmine.monitoring.mbeancmd.audit.Metric;
import org.ow2.jasmine.monitoring.mbeancmd.audit.MetricSorter;
import org.ow2.jasmine.monitoring.mbeancmd.audit.PollID;
import org.ow2.jasmine.monitoring.mbeancmd.audit.util.MetricMath;

public class Snap
extends AbstractCommand {
    public static final long DEFAULT_TIME_INTERVAL = 60000L;
    private AuditContext[] context = null;
    private Options options = null;
    private CommandLine commandLine = null;
    private ObjectName on = null;
    private String[] sort_attr = null;
    private String[] attributes = null;
    private int sortMode = -1;
    private PrintStream pout = null;
    private PrintStream perr = null;
    private CommandDispatcher cmdDispatcher = null;
    LinkedList<Metric> metrics = new LinkedList();
    private boolean printZeroValue = false;
    private boolean isDelta = false;
    private long timeInterval = 60000L;

    public Snap() {
        this.setOptions();
    }

    public int exec(CommandDispatcher cmdDispatcher) {
        this.cmdDispatcher = cmdDispatcher;
        PipedOutputStream out = new PipedOutputStream();
        this.pout = new PrintStream(out);
        PipedOutputStream err = new PipedOutputStream();
        this.perr = new PrintStream(err);
        Outer outer = null;
        Outer outer_err = null;
        try {
            outer = new Outer(out, System.out);
            outer_err = new Outer(err, System.err);
        }
        catch (IOException e) {
            // empty catch block
        }
        new Thread(outer_err).start();
        new Thread(outer).start();
        try {
            this.parseCommandLine(this.arguments);
        }
        catch (Exception e) {
            e.printStackTrace(this.perr);
            this.pout.close();
            this.perr.close();
            return 1;
        }
        if (this.context != null) {
            Collector collector = new Collector();
            collector.setContext(this.context);
            collector.setOnPattern(this.on);
            collector.setAttributes(this.attributes);
            collector.setPerr(this.perr);
            PollID baseline = null;
            PollID id = null;
            MetricSorter sorter = new MetricSorter();
            if (!this.isDelta) {
                id = collector.poll("snap");
            } else {
                baseline = collector.poll("baseline");
                Snap.sleep(this.timeInterval);
                id = collector.poll("snap");
                sorter.setBaseline(collector.getPoll(baseline));
            }
            for (int i = 0; i < this.sort_attr.length; ++i) {
                TreeSet<Metric> tset = sorter.sort(collector.getPoll(id), this.sort_attr[i], this.sortMode);
                LinkedList<Metric> mlist = new LinkedList<Metric>();
                for (Metric m : tset) {
                    mlist.add(m);
                }
                this.perr.println("\nPoll size : " + tset.size() + " ordered by " + this.sort_attr[i] + " - sum: " + MetricMath.sum(this.sort_attr[i], mlist));
                this.perr.flush();
                MetricSorter.printMetrics(this.pout, tset, this.sort_attr[i], this.printZeroValue);
            }
        } else {
            this.perr.println("No target.");
        }
        this.pout.close();
        this.perr.close();
        return 0;
    }

    public static void sleep(long delai) {
        try {
            Thread.sleep(delai);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String summary() {
        return "Audit MBean in multiple serveurs and prints a sorted output";
    }

    public void parseCommandLine(String[] args) throws ParseException, MalformedObjectNameException {
        String[] targets;
        BasicParser bp = new BasicParser();
        this.commandLine = bp.parse(this.options, args);
        this.setObjectName();
        this.attributes = this.commandLine.getOptionValues("a");
        if (this.attributes == null) {
            throw new ParseException("Missing argument : -a option requires an attribute list");
        }
        if (this.commandLine.hasOption("s")) {
            this.sort_attr = this.commandLine.getOptionValues("s");
            for (int i = 0; i < this.sort_attr.length; ++i) {
                boolean found = false;
                for (int j = 0; j < this.attributes.length; ++j) {
                    if (!this.sort_attr[i].equals(this.attributes[j])) continue;
                    found = true;
                }
                if (found) continue;
                throw new ParseException("The sort attribute " + this.sort_attr[i] + " is not in the list of collected attributes.");
            }
        } else {
            this.sort_attr = new String[]{this.attributes[0]};
        }
        if (this.commandLine.hasOption("m")) {
            String mode = this.commandLine.getOptionValue("m");
            if ("up".equalsIgnoreCase(mode)) {
                this.sortMode = 1;
            } else if ("down".equalsIgnoreCase(mode)) {
                this.sortMode = -1;
            }
        }
        if (this.commandLine.hasOption("z")) {
            this.printZeroValue = true;
        }
        if ((targets = JmxHelper.getJmxTargets(this.commandLine.getOptionValues("target"))) != null && targets.length > 0) {
            this.context = new AuditContext[targets.length];
            for (int i = 0; i < this.context.length; ++i) {
                this.context[i] = new AuditContext();
                this.context[i].setName(targets[i]);
                this.context[i].setJmxUrl(JmxHelper.getJmxUrl(targets[i]));
                this.context[i].setJmxap(new JmxAp(this.context[i].getJmxUrl(), this.cmdDispatcher));
            }
        }
        if (this.commandLine.hasOption("delta")) {
            String interval = this.commandLine.getOptionValue("delta", Long.toString(60L));
            try {
                this.timeInterval = Long.parseLong(interval) * 1000L;
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid time interval argument in the '-delta' option : " + interval);
            }
            this.isDelta = true;
        }
    }

    private void setObjectName() throws MalformedObjectNameException {
        this.on = ObjectName.getInstance(this.commandLine.getOptionValue("name"));
    }

    private void setOptions() {
        this.options = new Options();
        this.options.addOption("z", "zero", false, "print zero values (not printed per default)");
        Option name = new Option("name", "objectName", true, "An ObjectName passed to every method");
        name.setRequired(true);
        name.setArgName("mbean name");
        name.setArgs(1);
        this.options.addOption(name);
        Option atts = new Option("a", "atts", true, "attributes to poll");
        atts.setRequired(true);
        atts.setOptionalArg(false);
        atts.setArgs(-2);
        atts.setArgName("attributes");
        this.options.addOption(atts);
        Option sortAtt = new Option("s", "sort", true, "Sort according to an attribute");
        sortAtt.setRequired(false);
        sortAtt.setOptionalArg(false);
        sortAtt.setArgName("sort_attribute");
        sortAtt.setArgs(-2);
        this.options.addOption(sortAtt);
        Option sortMode = new Option("m", "mode", true, "Sort mode (ascending or descending)");
        sortMode.setRequired(false);
        sortMode.setOptionalArg(false);
        sortMode.setArgName("mode");
        sortMode.setArgs(1);
        this.options.addOption(sortMode);
        Option delta = new Option("delta", "delta", true, "computes delta from a baseline");
        delta.setRequired(false);
        delta.setOptionalArg(true);
        delta.setArgName("interval");
        delta.setArgs(1);
        this.options.addOption(delta);
        Option target = new Option("target", "target", true, "instances to poll");
        target.setRequired(false);
        target.setOptionalArg(true);
        target.setArgs(-2);
        target.setArgName("instances");
        this.options.addOption(target);
    }

    public String toString() {
        return this.on.toString();
    }
}

