/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxAp;
import org.ow2.jasmine.monitoring.mbeancmd.JmxHelper;
import org.ow2.jasmine.monitoring.mbeancmd.Outer;
import org.ow2.jasmine.monitoring.mbeancmd.context.StatContext;
import org.ow2.jasmine.monitoring.mbeancmd.graph.Grapher;
import org.ow2.jasmine.monitoring.mbeancmd.graph.conf.Configurator;
import org.ow2.jasmine.monitoring.mbeancmd.jasmine.JasmineConnector;

public class Stat
extends AbstractCommand {
    private StatContext[] context = null;
    private Options options = null;
    private CommandLine commandLine = null;
    private ObjectName on = null;
    private long period = 10L;
    private long refreshPeriod = 300L;
    private boolean isRefreshable = true;
    private String graphDef = null;
    private String outputFilePath = null;
    private String jasmineURI = null;
    private PrintStream pout = null;
    private String separator = ";";
    private String header = null;
    private CommandDispatcher cmdDispatcher = null;
    private long warningTrigger = 0L;

    public Stat() {
        this.setOptions();
    }

    public static void main(String[] args) {
        Stat p = new Stat();
        p.setArgs("stat", args);
        p.exec(null);
    }

    public int exec(CommandDispatcher cmdDispatcher) {
        this.cmdDispatcher = cmdDispatcher;
        try {
            this.parseCommandLine(this.arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        PipedOutputStream out = new PipedOutputStream();
        this.pout = new PrintStream(out);
        Outer outer = null;
        try {
            if (this.outputFilePath != null) {
                outer = new Outer(out, new File(this.outputFilePath));
            } else if (this.jasmineURI == null) {
                outer = new Outer(out, System.out);
            }
            if (this.jasmineURI != null) {
                if (outer == null) {
                    outer = JasmineConnector.connect(out, this.jasmineURI);
                } else {
                    Outer oldOuter = outer;
                    outer = JasmineConnector.connect(outer, this.jasmineURI);
                    new Thread(oldOuter).start();
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"Cannot set up file or jasmine output :  {0}", new Object[]{e.getMessage(), e});
        }
        if (this.graphDef != null) {
            try {
                PipedOutputStream sink = new PipedOutputStream();
                outer.setSink(sink);
                Grapher gr = new Grapher(sink, this.graphDef);
                gr.start();
            }
            catch (IOException e) {
                this.logger.error((Object)"Cannot set up graph output :  {0}", new Object[]{e.getMessage(), e});
            }
        }
        new Thread(outer).start();
        this.process();
        return 0;
    }

    public void help() {
        super.help();
        System.out.println("\nDTD for graph definitions:\n--------------------------\n\n");
        LineNumberReader ln = Configurator.getDTD();
        if (ln != null) {
            try {
                String line = null;
                while ((line = ln.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.logger.error((Object)"Error: DTD not found !", new Object[0]);
        }
    }

    public String summary() {
        return "Periodically probes MBeans in one or multiple J2EE servers";
    }

    public void parseCommandLine(String[] args) throws ParseException, MalformedObjectNameException {
        BasicParser bp = new BasicParser();
        this.commandLine = bp.parse(this.options, args);
        this.setObjectName();
        if (this.commandLine.hasOption("p")) {
            this.setPeriod();
        }
        if (this.commandLine.hasOption("r")) {
            this.setRefreshPeriod();
        }
        if (this.commandLine.hasOption("graph")) {
            this.graphDef = this.commandLine.getOptionValue("graph");
        }
        if (this.commandLine.hasOption("f")) {
            this.outputFilePath = this.commandLine.getOptionValue("f");
        }
        if (this.commandLine.hasOption("jasmine")) {
            this.jasmineURI = this.commandLine.getOptionValue("jasmine");
        }
        if (this.commandLine.hasOption("s")) {
            this.separator = this.commandLine.getOptionValue("s");
            Outer.setSeparator(this.separator);
        }
    }

    private void setObjectName() throws MalformedObjectNameException {
        this.on = new ObjectName(this.commandLine.getOptionValue("name"));
    }

    private void setPeriod() throws NumberFormatException {
        this.period = Long.parseLong(this.commandLine.getOptionValue("p"));
    }

    private void setRefreshPeriod() throws NumberFormatException {
        String val = this.commandLine.getOptionValue("r");
        if ("never".equalsIgnoreCase(val)) {
            this.isRefreshable = false;
        } else {
            this.refreshPeriod = Long.parseLong(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mbeanPoll() {
        String[] atts = this.getAttToPoll();
        MBeanServerConnection cnx = null;
        boolean goOn = this.context != null;
        boolean refreshNow = false;
        while (goOn) {
            for (int i = 0; i < this.context.length; ++i) {
                StatContext ctx = this.context[i];
                try {
                    cnx = ctx.getJmxap().getMBeanServerConnection();
                    long now = System.currentTimeMillis();
                    boolean bl = refreshNow = this.isRefreshable && now >= ctx.getRefreshDeadLine();
                    if (refreshNow) {
                        try {
                            ctx.setOnames(cnx.queryNames(this.on, null));
                            ctx.setRefreshDeadLine(now + this.refreshPeriod * 1000L);
                            this.logger.info((Object)"MBean discovery: succesful probe, {0}", new Object[]{ctx.getName()});
                        }
                        catch (IOException e) {
                            this.logger.error((Object)"MBean discovery: failed probe, server {0} , caught exception , message: {1}", new Object[]{ctx.getName(), e.getMessage()});
                            throw e;
                        }
                    }
                    Iterator<ObjectName> it = ctx.getOnames().iterator();
                    while (it.hasNext()) {
                        long t = System.currentTimeMillis();
                        ObjectName onGot = it.next();
                        try {
                            AttributeList attl = this.getAttributes(cnx, onGot, atts, ctx.getName());
                            this.printMBeanPoll(t, ctx, attl, onGot);
                        }
                        catch (Exception e) {
                            this.logger.error((Object)"Error on mbean {0} for {1} - {2}", new Object[]{onGot, ctx.getName(), e.getMessage()});
                        }
                    }
                    continue;
                }
                catch (IOException e) {
                    continue;
                }
                finally {
                    ctx.getJmxap().releaseMBeanServerConnection();
                }
            }
            try {
                Thread.sleep(this.period * 1000L);
            }
            catch (InterruptedException e) {
                goOn = false;
            }
        }
    }

    private AttributeList getAttributes(MBeanServerConnection cnx, ObjectName on, String[] atts, String target) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        AttributeList attl = null;
        boolean tryOneByOne = false;
        try {
            attl = cnx.getAttributes(on, atts);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (this.warningTrigger % (86400L / this.period) == 0L) {
                this.logger.warn((Object)"MBeanCmd stat : cannot get attributes in one shot, trying one by one ({0}) for {1}", new Object[]{on, target});
                ++this.warningTrigger;
            }
            tryOneByOne = true;
        }
        if (tryOneByOne) {
            attl = new AttributeList(atts.length);
            for (int i = 0; i < atts.length; ++i) {
                Attribute att = new Attribute(atts[i], cnx.getAttribute(on, atts[i]));
                attl.add(att);
            }
        }
        return attl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getAttToPoll() {
        String[] attsRequested;
        String[] atts = attsRequested = this.commandLine.getOptionValues("a");
        MBeanServerConnection cnx = null;
        JmxAp jmxap = null;
        for (int i = 0; i < this.context.length; ++i) {
            jmxap = this.context[i].getJmxap();
            cnx = jmxap.getMBeanServerConnection();
            jmxap.releaseMBeanServerConnection();
            if (cnx != null) break;
        }
        try {
            ObjectName onGot = null;
            cnx = jmxap.getMBeanServerConnection();
            Iterator<ObjectName> it = cnx.queryNames(this.on, null).iterator();
            if (it.hasNext()) {
                onGot = it.next();
            }
            if (attsRequested == null && onGot != null) {
                MBeanAttributeInfo[] info = cnx.getMBeanInfo(onGot).getAttributes();
                atts = new String[info.length];
                for (int i = 0; i < atts.length; ++i) {
                    atts[i] = info[i].getName();
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            jmxap.releaseMBeanServerConnection();
        }
        return atts;
    }

    private String getMBeanPollHeader(AttributeList attl) {
        if (this.header == null) {
            StringBuffer buf = new StringBuffer(512);
            buf.append("date");
            buf.append(this.separator);
            buf.append("time");
            buf.append(this.separator);
            buf.append("sname");
            buf.append(this.separator);
            buf.append("server");
            buf.append(this.separator);
            buf.append("domain");
            buf.append(this.separator);
            buf.append("mbean");
            Iterator it = attl.iterator();
            while (it.hasNext()) {
                buf.append(this.separator);
                Attribute att = (Attribute)it.next();
                if (att.getValue() != null && att.getValue().getClass().isArray()) {
                    this.putArrayIntoHeader(buf, att);
                    continue;
                }
                if (att.getValue() != null && att.getValue() instanceof Map) {
                    this.putMapIntoHeader(buf, att);
                    continue;
                }
                if (att.getValue() != null && att.getValue() instanceof CompositeData) {
                    this.putCompositeDataIntoHeader(buf, att);
                    continue;
                }
                buf.append(att.getName());
            }
            this.header = buf.toString();
        }
        return this.header;
    }

    private void putArrayIntoHeader(StringBuffer buf, Attribute att) {
        Object obj = att.getValue();
        int length = Array.getLength(obj);
        for (int i = 0; i < length; ++i) {
            buf.append(i == 0 ? "" : this.separator);
            buf.append(att.getName());
            buf.append("_");
            buf.append(i);
        }
    }

    private void putMapIntoHeader(StringBuffer buf, Attribute att) {
        Map map = (Map)att.getValue();
        TreeSet ts = new TreeSet(map.keySet());
        Iterator it = ts.iterator();
        String sep = "";
        while (it.hasNext()) {
            buf.append(sep);
            sep = this.separator;
            buf.append(att.getName());
            buf.append("_");
            buf.append(it.next());
        }
    }

    private void putCompositeDataIntoHeader(StringBuffer buf, Attribute att) {
        CompositeData cdata = (CompositeData)att.getValue();
        Set<String> itemNames = cdata.getCompositeType().keySet();
        Iterator<String> it = itemNames.iterator();
        String sep = "";
        while (it.hasNext()) {
            buf.append(sep);
            sep = this.separator;
            buf.append(att.getName());
            buf.append("_");
            buf.append((Object)it.next());
        }
    }

    private void printMBeanPoll(long t, StatContext ctx, AttributeList attl, ObjectName oname) {
        if (this.header == null) {
            this.pout.println(this.getMBeanPollHeader(attl));
        }
        Date d = new Date(t);
        this.pout.print(SIMPLEDATEFORMAT.format(d));
        this.pout.print(this.separator);
        this.pout.print(t);
        this.pout.print(this.separator);
        this.pout.print(ctx.getJmxUrl());
        this.pout.print(this.separator);
        this.pout.print(ctx.getServer());
        this.pout.print(this.separator);
        this.pout.print(ctx.getDomain());
        this.pout.print(this.separator);
        this.pout.print(oname);
        Iterator it = attl.iterator();
        while (it.hasNext()) {
            this.pout.print(this.separator);
            Attribute att = (Attribute)it.next();
            if (att.getValue() != null && att.getValue().getClass().isArray()) {
                Object obj = att.getValue();
                int length = Array.getLength(obj);
                for (int i = 0; i < length; ++i) {
                    this.pout.print((i == 0 ? "" : this.separator) + Array.get(obj, i));
                }
                continue;
            }
            if (att.getValue() != null && att.getValue() instanceof Map) {
                Map map = (Map)att.getValue();
                TreeSet ts = new TreeSet(map.keySet());
                String sep = "";
                Iterator it2 = ts.iterator();
                while (it2.hasNext()) {
                    this.pout.print(sep);
                    sep = this.separator;
                    this.pout.print(map.get(it2.next()));
                }
                continue;
            }
            if (att.getValue() != null && att.getValue() instanceof CompositeData) {
                CompositeData cdata = (CompositeData)att.getValue();
                Set<String> itemNames = cdata.getCompositeType().keySet();
                Iterator<String> it2 = itemNames.iterator();
                String sep = "";
                while (it2.hasNext()) {
                    this.pout.print(sep);
                    sep = this.separator;
                    this.pout.print(cdata.get(it2.next()));
                }
                continue;
            }
            this.pout.print(att.getValue());
        }
        this.pout.println();
    }

    private void setOptions() {
        this.options = new Options();
        this.options.addOption("v", "verbose", false, "Verbose mode");
        Option name = new Option("name", "objectName", true, "An ObjectName passed to every method");
        name.setRequired(true);
        name.setArgName("mbean name");
        name.setArgs(1);
        this.options.addOption(name);
        Option atts = new Option("a", "atts", true, "attributes to poll");
        atts.setRequired(false);
        atts.setOptionalArg(true);
        atts.setArgs(-2);
        atts.setArgName("attributes");
        this.options.addOption(atts);
        Option period = new Option("p", "period", true, "Polling period");
        period.setRequired(false);
        period.setArgName("period");
        period.setArgs(1);
        this.options.addOption(period);
        Option refresh = new Option("r", "refresh", true, "Period for rebuilding the mbean list");
        refresh.setRequired(false);
        refresh.setArgName("refreshPeriod");
        refresh.setArgs(1);
        this.options.addOption(refresh);
        Option graph = new Option("graph", "graph", true, "Enable graphical output");
        graph.setRequired(false);
        graph.setArgName("graphDefinition");
        graph.setArgs(1);
        this.options.addOption(graph);
        Option file = new Option("f", "file", true, "Send output to file instead of stdout");
        file.setRequired(false);
        file.setArgName("path");
        file.setArgs(1);
        this.options.addOption(file);
        Option jasmine = new Option("jasmine", "jasmine", true, "Output logged data to jasmine (will disable stdout)");
        jasmine.setRequired(false);
        jasmine.setArgName("jasmineURI");
        jasmine.setArgs(1);
        this.options.addOption(jasmine);
        Option separator = new Option("s", "separator", true, "Set the column separator");
        separator.setRequired(false);
        separator.setArgName("separator");
        separator.setArgs(1);
        this.options.addOption(separator);
        Option target = new Option("target", "target", true, "instances to poll");
        target.setRequired(false);
        target.setOptionalArg(true);
        target.setArgs(-2);
        target.setArgName("instances");
        this.options.addOption(target);
    }

    public String toString() {
        return this.on.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() {
        String[] targets = JmxHelper.getJmxTargets(this.commandLine.getOptionValues("target"));
        if (targets != null && targets.length > 0) {
            this.context = new StatContext[targets.length];
            for (int i = 0; i < this.context.length; ++i) {
                this.context[i] = new StatContext();
                this.context[i].setName(targets[i]);
                this.context[i].setJmxUrl(JmxHelper.getJmxUrl(targets[i]));
                this.context[i].setJmxap(new JmxAp(this.context[i].getJmxUrl(), this.cmdDispatcher));
                try {
                    ObjectName j2eeinstance = ObjectName.getInstance("*:j2eeType=J2EEServer,*");
                    MBeanServerConnection mbscnx = this.context[i].getJmxap().getMBeanServerConnection();
                    Iterator<ObjectName> onames = mbscnx.queryNames(j2eeinstance, null).iterator();
                    this.context[i].setServer(null);
                    while (this.context[i].getServer() == null) {
                        ObjectName server = onames.next();
                        this.context[i].setServer((String)mbscnx.getAttribute(server, "serverName"));
                        this.context[i].setDomain(server.getDomain());
                    }
                }
                catch (Exception e) {
                    this.context[i].setServer("unknown_server_name");
                    this.context[i].setDomain("unknown_domain");
                }
                finally {
                    this.context[i].getJmxap().releaseMBeanServerConnection();
                }
                this.logger.info((Object)"Target {0} - {1}", new Object[]{this.context[i].getName(), this.context[i].getJmxUrl()});
            }
            this.mbeanPoll();
        } else {
            this.logger.error((Object)"No target.", new Object[0]);
        }
    }
}

