/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.context.JmxContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public abstract class Sampler {
    protected Log logger = LogFactory.getLog(this.getClass());
    private String objectName = null;
    protected JmxContext context;

    public Sampler(JmxContext context) {
        this.context = context;
    }

    protected final MBeanServerConnection getMBeanServerConnection() {
        return this.context.getJmxap().getMBeanServerConnection();
    }

    protected void releaseMbeanServerConnection() {
        this.context.getJmxap().releaseMBeanServerConnection();
    }

    protected final ObjectName[] queryON(String onProto) {
        ObjectName[] ons = null;
        try {
            MBeanServerConnection cnx = this.getMBeanServerConnection();
            this.logger.debug((Object)"MBean discovery: starting search in server {0} ({1}) pattern {2}", new Object[]{this.context.getName(), this.context.getServer(), onProto});
            this.context.setOnames(cnx.queryNames(new ObjectName(onProto), null));
            if (!this.context.getOnames().isEmpty()) {
                this.logger.debug((Object)"MBean discovery: succesful probe, {0}", new Object[]{this.context.getName()});
                ons = this.context.getOnames().toArray(new ObjectName[this.context.getOnames().size()]);
                for (int i = 0; i < ons.length; ++i) {
                    this.logger.debug((Object)"MBean discovery: Found ObjectName in server {0} ({1} on domain {2}): {3}", new Object[]{this.context.getName(), this.context.getServer(), this.context.getDomain(), ons[i]});
                }
            }
            this.logger.debug((Object)"MBean discovery: search complete in server {0} ({1}) pattern {2}", new Object[]{this.context.getName(), this.context.getServer(), onProto});
        }
        catch (Exception e) {
            this.logger.warn((Object)"MBean discovery: failed probe, target {0} ({1}) pattern {2}\n", new Object[]{this.context.getName(), this.context.getServer(), onProto});
            this.logger.warn((Object)"Exception {0}\n", new Object[]{e.getMessage()});
        }
        return ons;
    }

    protected abstract String getDefaultOn();

    protected String getOn() {
        return this.objectName;
    }

    public void setOn(String onProto) {
        this.objectName = onProto;
    }

    public void init() {
        if (this.getOn() == null) {
            this.setOn(this.getDefaultOn());
        }
        this.queryON(this.getOn());
    }

    public final SampleData sample(SampleData previous) {
        SampleData data = this.newSampleData();
        try {
            data.setSampleTime(System.currentTimeMillis());
            this.poll(data);
            if (data.isValid()) {
                data.compute(previous);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed sampling", new Object[]{e});
        }
        if (data.isValid()) {
            return data;
        }
        return null;
    }

    public String getName() {
        return this.context.getName();
    }

    public String getJmxUrl() {
        return this.context.getJmxUrl();
    }

    public String getServer() {
        return this.context.getServer();
    }

    public String getDomain() {
        return this.context.getDomain();
    }

    protected abstract SampleData newSampleData();

    protected abstract SampleData poll(SampleData var1);
}

