/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 */

package org.ow2.jasmine.monitoring.mbeancmd.audit;

/**
 * @author waeselyf
 * 
 * Identifier of polls generated by a Collector
 */
public class PollID {

    /**
     * Constructor
     * @param name
     */
    public PollID(String name) {
        this.name = name;
        toRepr();
    }

    /**
     * String representation of a poll identifier
     */
    public String toString() {
        return xmlrepr.toString();
    }

    /**
     * 
     */
    public int hashCode() {
        return hashcode;
    }

    /**
     * Sets thhe string representation and compute the hashcode
     *
     */
    private void toRepr() {
        xmlrepr.setLength(0);
        xmlrepr.append("<![CDATA[<poll stamp=\"");
        xmlrepr.append(Long.toString(timestamp));
        xmlrepr.append("\">");
        xmlrepr.append(name);
        xmlrepr.append("</poll>]]>");
        hashcode = xmlrepr.toString().hashCode();
    }

    /**
     * @return the timestamp. A negative value means the timestamp is not set.
     */
    public long getTimestamp() {
        return timestamp;
    }

    /**
     * Initialise the timestamp
     */
    public void setStamp() {
        if (!isTimestampSet) {
            isTimestampSet = true;
            timestamp = System.currentTimeMillis();
            toRepr();
        }
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Name of the poll
     */
    private String name = null;

    /**
     * timestamp of the poll.
     */
    private long timestamp = -1;

    /**
     * timestamp can be set only once. this flag track the stamp
     */
    private boolean isTimestampSet = false;

    /**
     * String representation of the PollID
     */
    private StringBuilder xmlrepr = new StringBuilder(48);

    private int hashcode = -1;
}
