/**
 * JASMINe
 * Copyright (C) 2005-2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SamplerContext.java 6157 2010-03-16 14:39:48Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.context;


import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;

/**
 * Sampler context.
 * @author Guillaume Renault
 *
 */
public class SamplerContext extends JmxContext {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * Sampler.
     */
    private Sampler sampler = null;

    /**
     * Previous data.
     */
    private SampleData previousData = null;

    public Sampler getSampler() {
        return sampler;
    }

    public void setSampler(Sampler sampler) {
        this.sampler = sampler;
    }

    public SampleData getPreviousData() {
        return previousData;
    }

    public void setPreviousData(SampleData previousData) {
        this.previousData = previousData;
    }

    /**
     * Specific name convention for JOnAS JMX connectors.
     */
    public void setServer(String name) {
        if ("unknown_server_name".equals(name)) {
            if (jmxUrl != null) {
                int index = jmxUrl.lastIndexOf("connector_");
                if (index > 0) {
                    index = index + "connector_".length();
                    String jonasServerName = jmxUrl.substring(index);
                    super.setServer(jonasServerName);
                }
            }
        } else {
            super.setServer(name);
        }
    }

}
