/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: MuleDispatcher.java 3606 2009-05-04 12:08:19Z jlegrand $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.monitoring.mbeancmd.jasmine;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.mule.extras.client.MuleClient;
import org.mule.umo.UMOException;

/**
 * 
 */
public class MuleDispatcher implements Runnable {

    private String version = "v1";

    /**
     *
     */
    private BufferedReader reader;

    /**
     *
     */
    private String jasmineURI;

    public MuleDispatcher(BufferedReader reader, String jasmineURI) {
        this.reader = reader;
        this.jasmineURI = jasmineURI;
    }

    public void run() {

        try {
            MuleClient client = null;
            while (client == null) {
                Thread.sleep(1000);
                client = new MuleClient();
            }

            String header = "mbeancmd_values_" + version + "\n"
                    + reader.readLine() + "\n";

            while (true) {

                if (reader.ready()) {

                    String msg = header + reader.readLine();
                    try {
                        client.dispatch(jasmineURI, msg, null);
                    } catch (NullPointerException e) {

                        Logger.getLogger(MuleDispatcher.class.getName()).log(
                                Level.INFO,
                                "Mule stopped ... Message is not delivered anymore to "
                                        + jasmineURI);
                        break;
                    }
                }
                
                Thread.sleep(900);
            }

        } catch (UMOException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

    }

}
