/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JmxHelper {
    private static Log logger = LogFactory.getLog(JmxHelper.class);
    public static final String DEFAULT_URL = "service:jmx:rmi:///jndi/rmi://localhost:1099/jrmpconnector_jonas";
    public static final String DEFAULT_FILE = "jmxurls.properties";
    private static Map<String, String> jmxTargets = new TreeMap<String, String>();
    private static Map<String, String> jmxUsers = new TreeMap<String, String>();
    private static Map<String, String> jmxPasswords = new TreeMap<String, String>();
    private static Map<String, String> jmxProtocolProviderPackages = new TreeMap<String, String>();
    private static String defaultTarget = null;
    private static Context ctx = null;

    public static Context getContext() {
        if (ctx != null) {
            return ctx;
        }
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            logger.error((Object)"Error while creating initialContext : {0}. An unmanaged JMX connection will be used instead.", new Object[]{e.getMessage()});
        }
        return ctx;
    }

    public static String getDefaultJmxTarget() {
        return jmxTargets.get(defaultTarget);
    }

    public static String getDefaultTarget() {
        return defaultTarget;
    }

    public static String getJmxUser(String jmxUrl) {
        return jmxUsers.get(jmxUrl);
    }

    public static String getJmxPassword(String jmxUrl) {
        return jmxPasswords.get(jmxUrl);
    }

    public static String getJmxProtocolProviderPackage(String jmxUrl) {
        return jmxProtocolProviderPackages.get(jmxUrl);
    }

    public static String getJmxUrl(String name) {
        if (name == null) {
            return jmxTargets.get(defaultTarget);
        }
        if (name.startsWith("service:jmx:rmi")) {
            return name;
        }
        return jmxTargets.get(name);
    }

    public static String[] getJmxTargets() {
        String[] targets = null;
        if (!jmxTargets.isEmpty()) {
            targets = new String[jmxTargets.size()];
            targets = jmxTargets.keySet().toArray(targets);
        }
        return targets;
    }

    public static String[] getJmxTargets(String[] proposed) {
        int i;
        boolean all = false;
        String[] targetsArray = null;
        LinkedList<String> targetsList = new LinkedList<String>();
        if (proposed != null) {
            for (i = 0; i < proposed.length; ++i) {
                if ("all".equalsIgnoreCase(proposed[i])) {
                    all = true;
                    break;
                }
                String url = JmxHelper.getJmxUrl(proposed[i]);
                if (url == null) continue;
                targetsList.add(proposed[i]);
            }
        } else if (defaultTarget != null) {
            targetsList.add(defaultTarget);
        }
        if (all) {
            targetsArray = JmxHelper.getJmxTargets();
        } else if (targetsList.size() > 0) {
            targetsArray = new String[targetsList.size()];
            for (i = 0; i < targetsList.size(); ++i) {
                targetsArray[i] = (String)targetsList.get(i);
            }
        }
        return targetsArray;
    }

    private static void load() {
        Properties props;
        String name;
        String url;
        String dftTarget;
        Log logger;
        block25: {
            logger = LogFactory.getLog(JmxHelper.class);
            dftTarget = null;
            url = System.getProperty("jasmine.jmx.url");
            String user = System.getProperty("jasmine.jmx.user");
            String password = System.getProperty("jasmine.jmx.password");
            String filename = System.getProperty("jasmine.jmx.file");
            if (filename == null) {
                filename = DEFAULT_FILE;
            }
            name = null;
            if (url != null) {
                name = "jonas";
                if (url.matches(".*connector_.*")) {
                    int ix = url.lastIndexOf("connector_");
                    name = url.substring(ix + "connector_".length());
                }
                jmxTargets.put(name, url);
                if (user != null && password != null) {
                    jmxUsers.put(url, user);
                    jmxPasswords.put(url, password);
                }
                defaultTarget = name;
            }
            props = null;
            try {
                props = JmxHelper.getProperties(new File(filename));
            }
            catch (IOException ioe) {
                boolean isEmbeded = true;
                try {
                    Class.forName("org.ow2.jonas.lib.bootstrap.JProp");
                }
                catch (ClassNotFoundException cnfe) {
                    logger.warn((Object)"Cannot read JMX configuration file : {0}", new Object[]{filename});
                    isEmbeded = false;
                }
                if (!isEmbeded) break block25;
                try {
                    props = JmxHelper.getProperties(new File(JProp.getConfDir(), filename));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"class loaded : org.ow2.jonas.lib.bootstrap.JProp", new Object[0]);
                    }
                }
                catch (IOException e3) {
                    logger.warn((Object)"Cannot read JMX configuration file : {0} : {1}", new Object[]{filename, e3.getMessage()});
                }
            }
        }
        if (props != null && props.size() != 0) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (!key.startsWith("jasmine.jmx.url.")) continue;
                name = key.substring("jasmine.jmx.url.".length());
                url = props.getProperty(key);
                jmxTargets.put(name, url);
            }
            en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (key.startsWith("jasmine.jmx.user.")) {
                    name = key.substring("jasmine.jmx.user.".length());
                    url = jmxTargets.get(name);
                    if (url == null) {
                        logger.warn((Object)"Cannot set user for target {0}", new Object[]{name});
                        continue;
                    }
                    jmxUsers.put(url, props.getProperty(key));
                    continue;
                }
                if (key.startsWith("jasmine.jmx.password.")) {
                    name = key.substring("jasmine.jmx.password.".length());
                    url = jmxTargets.get(name);
                    if (url == null) {
                        logger.warn((Object)"Cannot set password for target {0}", new Object[]{name});
                        continue;
                    }
                    jmxPasswords.put(url, props.getProperty(key));
                    continue;
                }
                if (key.startsWith("jasmine.jmx.protocol.providers.")) {
                    name = key.substring("jasmine.jmx.protocol.providers.".length());
                    url = jmxTargets.get(name);
                    if (url == null) {
                        logger.warn((Object)"Cannot set protocol providers for target {0}", new Object[]{name});
                        continue;
                    }
                    jmxProtocolProviderPackages.put(url, props.getProperty(key));
                    continue;
                }
                if (!"jasmine.jmx.default.target".equals(key) || defaultTarget != null) continue;
                dftTarget = props.getProperty(key);
            }
        }
        if (defaultTarget == null) {
            if (dftTarget != null) {
                if (jmxTargets.get(dftTarget) != null) {
                    defaultTarget = dftTarget;
                } else {
                    logger.warn((Object)"jasmine.jmx.default.target property specifies an invalid default target {0}. No default target set.", new Object[]{dftTarget});
                }
            } else {
                defaultTarget = "jonas";
                jmxTargets.put(defaultTarget, DEFAULT_URL);
                logger.warn((Object)"jasmine.jmx.default.target property not set. Setting default target to: {0}.", new Object[]{defaultTarget});
                logger.warn((Object)"Setting jmxUrl to {0}.", new Object[]{DEFAULT_URL});
            }
        }
    }

    private static Properties getProperties(File propertyFile) throws IOException {
        Properties properties = new Properties();
        FileInputStream in = new FileInputStream(propertyFile);
        properties.load(in);
        in.close();
        return properties;
    }

    static {
        JmxHelper.load();
    }
}

