/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxAp;
import org.ow2.jasmine.monitoring.mbeancmd.JmxHelper;
import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SamplerFactory;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.XSampleData;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class XServerSampler {
    private Log logger = LogFactory.getLog(this.getClass());
    private CommandDispatcher commandDispatcher = null;
    private Map<String, String> manageeURLs = new TreeMap<String, String>();
    private String sampleType = null;
    private String onPattern = null;
    private SamplerContext[] contexts = null;
    private static final long SECOND = 1000L;

    public XServerSampler(String type) {
        this.sampleType = type;
    }

    public void addManagee(String name, String jmxUrl) {
        this.manageeURLs.put(name, jmxUrl);
    }

    public void setOnPattern(String objectNameAsString) {
        this.onPattern = objectNameAsString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mbeanPoll(long period, PrintStream out) {
        boolean printHeader = true;
        while (true) {
            SamplerContext context = null;
            SampleData data = null;
            for (int i = 0; i < this.contexts.length; ++i) {
                context = this.contexts[i];
                Sampler sampler = context.getSampler();
                try {
                    block15: {
                        try {
                            context.updateOnames(this.onPattern);
                        }
                        catch (MalformedObjectNameException moe) {
                            return;
                        }
                        catch (IOException ioe) {
                            continue;
                        }
                        data = null;
                        try {
                            SampleData prevData = context.getPreviousData();
                            data = sampler.sample(prevData);
                            boolean printed = this.printData(data, out, printHeader);
                            if (printed) {
                                printHeader = false;
                                if (!context.isStarted()) {
                                    context.setStarted(true);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!context.isStarted()) break block15;
                            System.err.println("Error sampling managee " + context.getName());
                        }
                    }
                    context.setPreviousData(data);
                }
                catch (Exception me) {}
                continue;
            }
            try {
                Thread.sleep(period * 1000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private boolean printData(SampleData data, PrintStream out, boolean printHeader) {
        if (data == null) {
            return false;
        }
        boolean emptyData = false;
        if (data instanceof XSampleData) {
            XSampleData xData = (XSampleData)data;
            emptyData = xData.getSampleData().isEmpty();
        }
        if (emptyData) {
            return false;
        }
        if (printHeader) {
            out.println(data.getPrintHeader());
            printHeader = false;
        }
        data.printData(out);
        return true;
    }

    private SamplerContext createSamplerContext(String name) throws Exception {
        SamplerContext samplerContext = new SamplerContext();
        samplerContext.setName(name);
        samplerContext.setJmxUrl(JmxHelper.getJmxUrl(name));
        samplerContext.setJmxap(new JmxAp(samplerContext.getJmxUrl(), this.commandDispatcher));
        this.setUpManagentInfos(samplerContext);
        Sampler sampler = SamplerFactory.newSampler(this.sampleType, this.onPattern, samplerContext);
        samplerContext.setSampler(sampler);
        return samplerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpManagentInfos(SamplerContext samplerContext) {
        try {
            ObjectName jvminstance = ObjectName.getInstance("*:j2eeType=JVM,*");
            MBeanServerConnection mbscnx = samplerContext.getJmxap().getMBeanServerConnection();
            Iterator<ObjectName> onames = mbscnx.queryNames(jvminstance, null).iterator();
            while (samplerContext.getServer() == null) {
                ObjectName oname = onames.next();
                samplerContext.setServer(oname.getKeyProperty("J2EEServer"));
                samplerContext.setDomain(oname.getDomain());
            }
        }
        catch (Exception ex) {
            samplerContext.setServer("unknown_server_name");
            samplerContext.setDomain("unknown_domain");
        }
        finally {
            samplerContext.getJmxap().releaseMBeanServerConnection();
        }
    }

    public final void process(long period, PrintStream out) {
        LinkedList<SamplerContext> samplerContextList = new LinkedList<SamplerContext>();
        for (Map.Entry<String, String> e : this.manageeURLs.entrySet()) {
            String targetName = e.getKey();
            try {
                SamplerContext ctx = this.createSamplerContext(targetName);
                samplerContextList.add(ctx);
            }
            catch (Exception ex) {
                return;
            }
        }
        this.contexts = samplerContextList.toArray(new SamplerContext[samplerContextList.size()]);
        this.mbeanPoll(period, out);
    }

    public void setCommandDispatcher(CommandDispatcher commandDispatcher) {
        this.commandDispatcher = commandDispatcher;
    }
}

