/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Command.java 1928 2008-07-30 08:45:19Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd;

/**
 * An MBeanCmd command.
 */
public interface Command {
    /**
     * Sets command name and arguments.
     *
     * @param cmd   Command name.
     * @param args  Command arguments.
     */
    void setArgs(final String cmd, final String[] args);

    /**
     * Executes the command.
     *
     * @return 0 if succeeded, an error code otherwise.
     */
    int exec(final CommandDispatcher cmdDispatcher);

    /**
     * Displays the help for this command.
     */
    void help();

    /**
     * Retrieves the name of the command.
     *
     * @return Name of the command.
     */
    String getName();

    /**
     * Retrieves the command's summary.
     *
     * @return Command's summary.
     */
    String summary();
}
