/**
 * JASMINe
 * Copyright (C) 2005-2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SFBSampler.java 6157 2010-03-16 14:39:48Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.io.IOException;
import java.util.Iterator;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;

/**
 * Sampler for retrieving data from stateful session beans.
 */
public class SFBSampler extends SessionBeanSampler {
    /**
     * Implementation of inherited method.
     *
     * @see Sampler#Sampler(String)
     */
    public SFBSampler(final SamplerContext context) {
        super(context);
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see Sampler#getDefaultOn()
     */
    public String getDefaultOnPattern() {
        return "*:j2eeType=StatefulSessionBean,*";
    }

    /**
     * Polls one stateful bean provider for data.
     *
     * @param on    Name of the provider.
     * @param data  SFBData to add polled information to.
     */
    protected void pollSessionBean(final ObjectName on, final SessionBeanData data) {
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        Attribute att;
        try {
            cnx = getMBeanServerConnection();
            al = cnx.getAttributes(on, attIds);
            releaseMbeanServerConnection();
            cnx = null;
            Iterator it = al.iterator();
            while (it.hasNext()) {
                att = (Attribute) it.next();
                data.setAttribute(att);
            }
            data.setServerInfo(getName(), getJmxUrl(), getServer(), getDomain());
            data.setValid(true);
        } catch (InstanceNotFoundException e) {
            e.printStackTrace(System.err);
        } catch (ReflectionException e) {
            e.printStackTrace(System.err);
        } catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    /**
     * Polled attribute identifiers.
     */
    private static final String[] attIds = {
             "name",
             "cacheSize",
             "poolSize",
             "minPoolSize",
             "maxCacheSize",
             "sessionTimeOut"
    };
}
