/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CmdThread.java 7005 2010-10-25 08:52:43Z durieuxp $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd;

import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher.CommandStatus;

/**
 * Extend Thread class in order to implement command status control
 * and execution delay.
 * Status control is used when command control is made by the EventSwitchManager MBean.
 * Execution delay is currently used by the MBeanCmdWrapper that is is used by Mule.
 * @author Adriana Danes
 */
public class CmdThread extends Thread {

    protected String[] commandArgs = null;
    protected String cmdStatus = CommandStatus.STARTED.toString();
    /**
     * delay to start used by the MBeanCmdWrapper
     */
    protected long delay = 0;

    /**
     * Create a thread in order to execute a command.
     * @param args the command's arguments.
     */
    public CmdThread(final String[] args, final long delay) {
        this.commandArgs = args;
        this.delay = delay;
    }

    @Override
    /**
     * Start the command.
     */
    public void run() {
        if (delay != 0) {
            final long time = System.currentTimeMillis();
            synchronized (this) {
                while(System.currentTimeMillis() < time + delay) {
                    try {
                        wait(delay);
                    } catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        CommandDispatcher.start(commandArgs);
    }

    /**
     *
     * @return
     */
    public String getCmdStatus() {
        return cmdStatus;
    }

    /**
     * Status set by the command dispatcher.
     * @param cmdStatus new status
     */
    public void setCmdStatus(String cmdStatus) {
        this.cmdStatus = cmdStatus;
    }

    protected String error;

    public String getErrorMessage() {
        return this.error;
    }

    public void setErrorMessage(String mess) {
        this.error = mess;
    }


}
