/**
 * 
 */
package org.ow2.jasmine.monitoring.mbeancmd.audit;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TreeSet;

import javax.management.Attribute;
import javax.management.AttributeList;

import org.ow2.jasmine.monitoring.mbeancmd.audit.util.MetricMath;

/**
 * @author waeselyf
 * 
 */
public class MetricSorter {

    public MetricSorter() {
    }

    public void resetBaseline() {
        if (baseline != null) {
            baseline.clear();
            baseline = null;
        }
    }

    public void setBaseline(HashMap<String, Metric> m) {

        resetBaseline();
        baseline = m;
    }

    public void setBaseline(LinkedList<Metric> l) {

        resetBaseline();
        baseline = new HashMap<String, Metric>();
        for (Metric m : l) {
            baseline.put(m.getRadical(), m);
        }
    }

    public TreeSet<Metric> sort(LinkedList<Metric> metrics, String attribute) {
        return sort(metrics, attribute, MetricComparator.DESCENDING_ORDER);
    }

    public TreeSet<Metric> sort(LinkedList<Metric> metrics, String attribute, int sortMode) {

        LinkedList<Metric> delta = metrics;
        if (baseline != null) {
            delta = new LinkedList<Metric>();
            for (Metric m : metrics) {
                Metric b = baseline.get(m.getRadical());
                Metric r = Metric.delta(m, b, attribute);
                if (r != null) {
                    delta.add(r);
                }
            }
        }

        TreeSet<Metric> tset = new TreeSet(new MetricComparator(attribute, sortMode));
        tset.addAll(delta);
        return tset;
    }

    public static void printMetrics(PrintStream pout, TreeSet<Metric> tset, String attribute) {
        printMetrics(pout, tset, attribute, false, false);
    }

    public static void printMetrics(PrintStream pout, TreeSet<Metric> tset, String attribute, boolean printZeroValue) {
        printMetrics(pout, tset, attribute, printZeroValue, false);
    }

    public static void printMetrics(PrintStream pout, TreeSet<Metric> tset, String attribute, boolean printZeroValue,
            boolean printStats) {

        DecimalFormat df = new DecimalFormat("####.#", new DecimalFormatSymbols(Locale.ENGLISH));

        String[] atts = getAttributeNames(tset.first(), attribute);
        if (atts == null) {
            return;
        }

        // Print header
        pout.print(attribute + ";range;source;mbean");
        if (printStats) {
            for (int i = 1; i < atts.length; i++) {
                pout.print(";" + atts[i]);
            }
        }
        pout.println();

        // print attributes
        for (Metric m : tset) {

            Attribute att = m.getAttribute(attribute);

            // print only if attribute is present
            boolean printable = printZeroValue || MetricMath.isNonZero(att);
            if (printable) {
                double range = MetricMath.range(MetricMath.toDouble(att));
                pout.print(att.getValue() + ";" + df.format(range) + ";" + m.getSource() + ";" + m.getName());
                if (printStats) {
                    for (int i = 1; i < atts.length; i++) {
                        pout.print(";" + m.getAttribute(atts[i]).getValue());
                    }                    
                }
                pout.println();
            }

        }
    }

    /**
     * 
     * @param m
     * @param attribute
     * @return a String array of all the attributes of the metric, with
     *         attribute as first element, or null.
     */
    private static String[] getAttributeNames(Metric m, String attribute) {
        String[] atts = null;
        Attribute att = m.getAttribute(attribute);
        if (att != null) {
            AttributeList l = m.getAttributes();
            atts = new String[l.size()];
            int n = 0;
            atts[n++] = attribute;
            Iterator it = l.iterator();
            while (it.hasNext()) {
                String attName = ((Attribute) it.next()).getName();
                if (!attName.equals(attribute)) {
                    atts[n++] = attName;
                }
            }
        }
        return atts;
    }

    /**
     * 
     */
    private HashMap<String, Metric> baseline = null;
}
