/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Help.java 7005 2010-10-25 08:52:43Z durieuxp $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import org.ow2.jasmine.monitoring.mbeancmd.Command;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;

/**
 * Command that displays application help.
 */
public class Help implements Command {
    /**
     * Implementation of inherited method.
     *
     * Sets command name and arguments.
     *
     * @see org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand#setArgs(String,
     *      String[])
     *
     * @param cmd Command name.
     * @param args Command arguments.
     */
    public void setArgs(final String cmd, final String[] args) {
        this.name = cmd.toLowerCase();
        this.arguments = args;
    }

    /**
     * Abstract redefinition of inherited method.
     *
     * Executes the command.
     *
     * @see org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand#exec()
     *
     * @return 0 if succeeded, an error code otherwise.
     */
    public int exec(final CommandDispatcher cmdDispatcher) {
        if (this.arguments == null) {
            System.out.println("\nAvailable commands:\n");
            String[] cmds = cmdDispatcher.getAvailableCommands();
            for (int i = 0; i < cmds.length; i++) {
                Command cmd = cmdDispatcher.getCommand(cmds[i]);
                System.out.println(cmds[i] + " - " + cmd.summary());
            }
            System.out.println();
            this.help();
        } else {
            for (int i = 0; i < this.arguments.length; i++) {
                Command cmd = cmdDispatcher.getCommand(this.arguments[i]);
                if (cmd == null) {
                    System.out.println("Unknown command: " + this.arguments[i]);
                } else {
                    cmd.help();
                }
                System.out.println();
            }
        }
        return 0;
    }

    /**
     * Abstract redefinition of inherited method.
     *
     * Retrieves the command's summary.
     *
     * @see org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand#summary()
     *
     * @return Command's summary.
     */
    public String summary() {
        return "provides help on available commands";
    }

    /**
     * Implementation of inherited method.
     *
     * Displays the help for this command.
     *
     * @see org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand#help()
     * @see org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand#getHelpDoc()
     */
    public void help() {
        System.out.println("Usage: help [ command, ... ]\n"
                + "\t- without arguments, lists a summary of the available commands\n"
                + "\t- with arguments, prints full help for each passed command\n");
    }

    /**
     * Implementation of inherited method.
     *
     * Retrieves the name of the command.
     *
     * @see org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand#getName()
     *
     * @return Name of the command.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Name of the command.
     */
    private String name = null;

    /**
     * Command arguments.
     */
    private String[] arguments = null;

	public void stop() {
	}
}
